#ifndef UTILITIES_H
#define UTILITIES_H

#include <math.h>

void Sort(int* item, int first, int last);
bool Find(int* item, int first, int last, int key);

template<class T>
inline void Swap(T& a, T& b)
{
  T tmp = a;
  a = b;
  b = tmp;
}

template<class T>
void Sort(int* item1, T* item2, int first, int last)
{
  /* Perform selection sort. */

  for (int i = first; i < last - 1; i++)
  {
    int k = i;
    for (int j = i + 1; j < last; j++)
      if (item1[j] < item1[k])
        k = j;
    if (k != i)
    {
      Swap(item1[k], item1[i]);
      Swap(item2[k], item2[i]);
    }
  }
}

inline double Max(double a, double b)
{
  if (a > b)
    return a;
  return b;
}

inline double Abs(double value)
{
  return fabs(value);
}

#endif
