#ifndef UPDATE_STACK_H
#define UPDATE_STACK_H

#include <iostream.h>
#include <fstream.h>

#include "Array.h"
#include "UpdateMatrix.h"
#include "Error.h"

#undef __CLASS__
#define __CLASS__ "UpdateStack"
template<class T>
class UpdateStack
{
  private:
    int maximumSize_;
    int currentSize_;
    Array<UpdateMatrix<T>*>* entry_;

    UpdateStack(const UpdateStack<T>&);
    UpdateStack<T>& operator=(const UpdateStack<T>&);

    void allocate(void);
    void free(void);

  public:
    UpdateStack();
    UpdateStack(int maximumSize);
    virtual ~UpdateStack();

    int getMaximumSize(void) const
      {return maximumSize_;}
    int getCurrentSize(void) const
      {return currentSize_;}
    Array<UpdateMatrix<T>*>* getEntry(void)
      {return entry_;}
    const Array<UpdateMatrix<T>*>* getEntry(void) const
      {return entry_;}

    void resize(int maximumSize);
    int getHeapSize(void) const;
    bool check(void) const;

    bool empty(void) const
      {return (currentSize_ == 0);}
    bool full(void) const
      {return (currentSize_ == maximumSize_);}
    UpdateMatrix<T>* getTopEntry(void) const;
    void push(UpdateMatrix<T>* updateMatrix);
    UpdateMatrix<T>* pop(void);
};

#undef __FUNC__
#define __FUNC__ "allocate"
template<class T>
void UpdateStack<T>::allocate(void)
{
  BEGIN_FUNCTION();

  try
  {
    entry_ = new Array<UpdateMatrix<T>*>(maximumSize_);
  }
  catch (...)
  {
    SET_ERROR1(MemoryAllocation);
  }

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "free"
template<class T>
void UpdateStack<T>::free(void)
{
  BEGIN_FUNCTION();

  UpdateMatrix<T>** entryItem = entry_->getItem();

  for (int k = 0; k < currentSize_; k++)
    delete entryItem[k];
  delete entry_;
  entry_ = 0;

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "UpdateStack"
template<class T>
UpdateStack<T>::UpdateStack():
  maximumSize_(0),
  currentSize_(0),
  entry_(0)
{
  BEGIN_FUNCTION();

  allocate();

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "UpdateStack"
template<class T>
UpdateStack<T>::UpdateStack(int maximumSize):
  maximumSize_(maximumSize),
  currentSize_(0),
  entry_(0)
{
  BEGIN_FUNCTION();

  allocate();

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "~UpdateStack"
template<class T>
UpdateStack<T>::~UpdateStack()
{
  BEGIN_FUNCTION();

  free();

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "resize"
template<class T>
void UpdateStack<T>::resize(int maximumSize)
{
  BEGIN_FUNCTION();

  free();
  maximumSize_ = maximumSize;
  currentSize_ = 0;
  allocate();

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "getHeapSize"
template<class T>
int UpdateStack<T>::getHeapSize(void) const
{
  BEGIN_FUNCTION();

  int heapSize = entry_->getHeapSize();
  for (int k = 0; k < currentSize_; k++)
    heapSize += entry_[i]->getHeapSize();

  END_FUNCTION();

  return heapSize;
}

#undef __FUNC__
#define __FUNC__ "check"
template<class T>
bool UpdateStack<T>::check(void) const
{
  BEGIN_FUNCTION();

  END_FUNCTION();

  if (maximumSize_ < 0)
    return false;
  if (currentSize_ < 0)
    return false;
  if (maximumSize_ < currentSize_)
    return false;
  return true;
}

#undef __FUNC__
#define __FUNC__ "getTopEntry"
template<class T>
UpdateMatrix<T>* UpdateStack<T>::getTopEntry(void) const
{
  BEGIN_FUNCTION();

  if (empty())
    SET_ERROR1(EmptyStack);

  END_FUNCTION();

  return entry_[currentSize_];
}

#undef __FUNC__
#define __FUNC__ "push"
template<class T>
void UpdateStack<T>::push(UpdateMatrix<T>* updateMatrix)
{
  BEGIN_FUNCTION();

  if (full())
    SET_ERROR1(FullStack);

  UpdateMatrix<T>** entryItem = entry_->getItem();

  entryItem[currentSize_++] = updateMatrix;

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "pop"
template<class T>
UpdateMatrix<T>* UpdateStack<T>::pop(void)
{
  BEGIN_FUNCTION();

  if (empty())
    SET_ERROR2(EmptyStack, 0);

  UpdateMatrix<T>** entryItem = entry_->getItem();

  END_FUNCTION();

  return entryItem[--currentSize_];
}

#endif
