/*
   Authors: Florin Dobrian & Alex Pothen
   Date: July, 1998
*/

#ifndef TIMER_H
#define TIMER_H

#include <sys/times.h>
#include <limits.h>
#include <unistd.h>

class Timer
{
  private:
    clock_t beginWall;
    clock_t endWall;
    struct tms beginCpu;
    struct tms endCpu;

  public:
    void start();
    void stop();
    float getWallTime();
    float getCpuTime();
    float getUserCpuTime();
    float getSystemCpuTime();
};

#endif
