#ifndef SYMBOLIC_H
#define SYMBOLIC_H

#include <iostream.h>
#include <fstream.h>

#include "Complex.h"
#include "Array.h"
#include "SparseMatrix.h"
#include "Permutation.h"
#include "EliminationForest.h"
#include "Error.h"
#include "Utilities.h"

#undef __CLASS__
#define __CLASS__ "Symbolic"
class Symbolic
{
  private:
    int numberOfFronts_;
    int numberOfRowIndices_;
    Array<int>* frontPointer_;
    Array<int>* rowIndex_;

    Symbolic(const Symbolic&);
    Symbolic& operator=(const Symbolic&);

    void allocate(void);
    void free(void);

    void initialize(const Array<int>* aColumnPointer,
                    const Array<int>* aRowIndex,
                    const Permutation& p,
                    const EliminationForest& f);

  public:
    Symbolic();
    Symbolic(int numberOfFronts, int numberOfRowIndices);
    virtual ~Symbolic();

    int getNumberOfFronts(void) const
      {return numberOfFronts_;}
    int getNumberOfRowIndices(void) const
      {return numberOfRowIndices_;}
    Array<int>* getFrontPointer(void)
      {return frontPointer_;}
    const Array<int>* getFrontPointer(void) const
      {return frontPointer_;}
    Array<int>* getRowIndex(void)
      {return rowIndex_;}
    const Array<int>* getRowIndex(void) const
      {return rowIndex_;}

    void resize(int numberOfFronts, int numberOfRowIndices);
    int getHeapSize(void) const;
    bool check(void) const;

    void print(void) const;
    void save(const char* fileName) const;

    void initialize(const SparseMatrix<double>& a,
                    const Permutation& p,
                    const EliminationForest& f);
    void initialize(const SparseMatrix<Complex>& a,
                    const Permutation& p,
                    const EliminationForest& f);
};

#endif
