#ifndef QUEUE_H
#define QUEUE_H

#include <iostream.h>
#include <fstream.h>

#include "Array.h"
#include "Error.h"

#undef __CLASS__
#define __CLASS__ "Queue"
class Queue
{
  private:
    int maximumSize_;
    int currentSize_;
    int firstUsedPointer_;
    int lastUsedPointer_;
    int firstEmptyPointer_;
    Array<int>* entry_;
    Array<int>* nextPointer_;

    Queue(const Queue&);
    Queue& operator=(const Queue&);

    void allocate(void);
    void free(void);

    void initializeNextPointer(void);

  public:
    Queue();
    Queue(int maximumSize);
    virtual ~Queue();

    int getMaximumSize(void) const
      {return maximumSize_;}
    int getCurrentSize(void) const
      {return currentSize_;}

    void resize(int order);
    int getHeapSize(void) const;
    bool check(void) const;

    bool empty(void) const
      {return (currentSize_ == 0);}
    bool full(void) const
      {return (currentSize_ == maximumSize_);}
    void enqueue(int value);
    int dequeue(void);
    void remove(int value);
};

#endif
