#ifndef PERMUTATION_H
#define PERMUTATION_H

#include <iostream.h>
#include <fstream.h>

#include "Array.h"
#include "Error.h"

#undef __CLASS__
#define __CLASS__ "Permutation"
class Permutation
{
  private:
    int order_;
    Array<int>* oldToNew_;
    Array<int>* newToOld_;

    Permutation(const Permutation&);
    Permutation& operator=(const Permutation&);

    void allocate(void);
    void free(void);

  public:
    Permutation();
    Permutation(int order);
    virtual ~Permutation();

    int getOrder(void) const
      {return order_;}
    Array<int>* getOldToNew(void)
      {return oldToNew_;}
    const Array<int>* getOldToNew(void) const
      {return oldToNew_;}
    Array<int>* getNewToOld(void)
      {return newToOld_;}
    const Array<int>* getNewToOld(void) const
      {return newToOld_;}

    void resize(int order);
    int getHeapSize(void) const;
    bool check(void) const;

    void print(void) const;
    void load(const char* fileName);
    void save(const char* fileName) const;

    void initialize(void);
    void compose(const Permutation& permutation);
};

#endif
