#ifndef MULTIPLY_H
#define MULTIPLY_H

#include <iostream.h>
#include <fstream.h>

#include "Array.h"
#include "SparseMatrix.h"
#include "Vector.h"
#include "Error.h"

#undef __CLASS__
#define __CLASS__
template<class T>
class Multiply
{
  private:
    const SparseMatrix<T>* a_;
    const Vector<T>* x_;
    Vector<T>* b_;

    Multiply(const Multiply<T>&);
    Multiply<T>& operator=(const Multiply<T>&);

  public:
    Multiply();
    virtual ~Multiply();

    void setA(const SparseMatrix<T>& a)
      {a_ = &a;}
    void setX(const Vector<T>& x)
      {x_ = &x;}
    void setB(Vector<T>& b)
      {b_ = &b;}

    void run(void);
};

#undef __FUNC__
#define __FUNC__ "Multiply"
template<class T>
Multiply<T>::Multiply():
  a_(0),
  x_(0),
  b_(0)
{
  BEGIN_FUNCTION();

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "~Multiply"
template<class T>
Multiply<T>::~Multiply()
{
  BEGIN_FUNCTION();

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "run"
template<class T>
void Multiply<T>::run(void)
{
  BEGIN_FUNCTION();

  if (a_ == 0)
    SET_ERROR1(InvalidInput);

  if (x_ == 0)
    SET_ERROR1(InvalidInput);

  if (b_ == 0)
    SET_ERROR1(InvalidInput);

  if (a_->getOrder() != x_->getOrder())
    SET_ERROR1(InvalidInput);

  if (a_->getOrder() != b_->getOrder())
    SET_ERROR1(InvalidInput);

  int order = a_->getOrder();

  const int* aColumnPointerItem = a_->getColumnPointer()->getItem();
  const int* aRowIndexItem = a_->getRowIndex()->getItem();
  const T* aEntryItem = a_->getEntry()->getItem();
  const T* xEntryItem = x_->getEntry()->getItem();
  T* bEntryItem = b_->getEntry()->getItem();

  for (int i = 0; i < order; i++)
    bEntryItem[i] = 0;
  for (int j = 0; j < order; j++)
    for (int p = aColumnPointerItem[j]; p < aColumnPointerItem[j + 1]; p++)
      bEntryItem[aRowIndexItem[p]] += aEntryItem[p] * xEntryItem[j];

  END_FUNCTION();
}

#endif
