#ifndef MINIMUM_DEGREE_ORDER_H
#define MINIMUM_DEGREE_ORDER_H

#include <iostream.h>
#include <fstream.h>

void genmmd(int neqns,int xadj[],int adjncy[],int invp[],int perm[],
            int delta,int head[],int qsize[],int list[],int marker[],
            int maxint,int *ncsub);

#undef __CLASS__
#define __CLASS__ "MinimumDegreeOrder"
template<class T>
class MinimumDegreeOrder
{
  private:
    const SparseMatrix<T>* a_;
    Permutation* p_;

    MinimumDegreeOrder(const MinimumDegreeOrder<T>&);
    MinimumDegreeOrder<T>& operator=(const MinimumDegreeOrder<T>&);

  public:
    MinimumDegreeOrder();
    virtual ~MinimumDegreeOrder();

    void setA(const SparseMatrix<T>& a)
      {a_ = &a;}
    void setP(Permutation& p)
      {p_ = &p;}

    void run(void);
};

#undef __FUNC__
#define __FUNC__ "MinimumDegreeOrder"
template<class T>
MinimumDegreeOrder<T>::MinimumDegreeOrder():
  a_(0),
  p_(0)
{
  BEGIN_FUNCTION();

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "~MinimumDegreeOrder"
template<class T>
MinimumDegreeOrder<T>::~MinimumDegreeOrder()
{
  BEGIN_FUNCTION();

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "run"
template<class T>
void MinimumDegreeOrder<T>::run(void)
{
  BEGIN_FUNCTION();

  if (a_ == 0)
    SET_ERROR1(InvalidInput);

  if (p_ == 0)
    SET_ERROR1(InvalidInput);

  if (a_->getOrder() != p_->getOrder())
    SET_ERROR1(InvalidInput);

  Array<int> xadj(a_->getOrder() + 1);
  Array<int> adj(2 * a_->getNumberOfOffDiagonals());
  Array<int> head(a_->getOrder());
  Array<int> qsize(a_->getOrder());
  Array<int> list(a_->getOrder());
  Array<int> marker(a_->getOrder());
  CHECK_ERROR1();

  const int* aColumnPointerItem = a_->getColumnPointer()->getItem();
  const int* aRowIndexItem = a_->getRowIndex()->getItem();
  int* pOldToNewItem = p_->getOldToNew()->getItem();
  int* pNewToOldItem = p_->getNewToOld()->getItem();

  int* xadjItem = xadj.getItem();
  int* adjItem = adj.getItem();
  int* headItem = head.getItem();
  int* qsizeItem = qsize.getItem();
  int* listItem = list.getItem();
  int* markerItem = marker.getItem();

  {for (int j = 0; j <= a_->getOrder(); j++)
    xadjItem[j] = aColumnPointerItem[j];}

  {for (int j = 0, q = 0; j < a_->getOrder(); j++)
  {
    for (int p = aColumnPointerItem[j]; p < aColumnPointerItem[j + 1]; p++)
      if (aRowIndexItem[p] != j)
      {
        adjItem[q] = aRowIndexItem[p];
        q++;
      }
  }}

  {for (int j = 0; j <= a_->getOrder(); j++)
    xadjItem[j] -= j;}

  {for (int j = 0; j <= a_->getOrder(); j++)
    xadjItem[j]++;}

  {for (int p = 0; p < 2 * a_->getNumberOfOffDiagonals(); p++)
    adjItem[p]++;}

  const int delta = 0, maxInt = 8388607;
  int numberOfRowIndices;
  genmmd(a_->getOrder(), xadjItem, adjItem, pOldToNewItem, pNewToOldItem,
         delta, headItem, qsizeItem, listItem, markerItem,
         maxInt, &numberOfRowIndices);

  {for (int j = 0; j < a_->getOrder(); j++)
  {
    pOldToNewItem[j]--;
    pNewToOldItem[j]--;
  }}

  END_FUNCTION();
}

#endif
