#ifndef KERNELS_H
#define KERNELS_H

#include "Complex.h"

#ifdef FORTRAN_KERNELS
extern "C" {
void rcopy_(int* size, const double* x, double* y);
void raxpy_(int* size, double* a, const double* x, double* y);
void rscal1_(int* size, double* a, double* x);
void rscal2_(int* size, double* a, double* b, double* c, double* d,
             double* x1, double* x2);
void rdot_(int* size, double* a, const double* x, double* y);
void ccopy_(int* size, const Complex* x, Complex* y);
void caxpy_(int* size, Complex* a, const Complex* x, Complex* y);
void cscal1_(int* size, Complex* a, Complex* x);
void cscal2_(int* size, Complex* a, Complex* b, Complex* c, Complex* d,
             Complex* x1, Complex* x2);
void cdot_(int* size, Complex* a, const Complex* x, Complex* y);
}

inline void Copy(int* size, const double* x, double* y)
{
  rcopy_(size, x, y);
}

inline void Axpy(int* size, double* a, const double* x, double* y)
{
  raxpy_(size, a, x, y);
}

inline void Scal1(int* size, double* a, double* x)
{
  rscal1_(size, a, x);
}

inline void Scal2(int* size, double* a, double* b, double* c, double* d,
                   double* x1, double* x2)
{
  rscal2_(size, a, b, c, d, x1, x2);
}

inline void Dot(int* size, double* a, const double* x, double* y)
{
  rdot_(size, a, x, y);
}

inline void Copy(int* size, const Complex* x, Complex* y)
{
  ccopy_(size, x, y);
}

inline void Axpy(int* size, Complex* a, const Complex* x, Complex* y)
{
  caxpy_(size, a, x, y);
}

inline void Scal1(int* size, Complex* a, Complex* x)
{
  cscal1_(size, a, x);
}

inline void Scal2(int* size, Complex* a, Complex* b, Complex* c, Complex* d,
                   Complex* x1, Complex* x2)
{
  cscal2_(size, a, b, c, d, x1, x2);
}

inline void Dot(int* size, Complex* a, const Complex* x, Complex* y)
{
  cdot_(size, a, x, y);
}
#else
void Copy(int* size, const double* x, double* y);
void Axpy(int* size, double* a, const double* x, double* y);
void Scal1(int* size, double* a, double* x);
void Scal2(int* size, double* a, double* b, double* c, double* d,
           double* x1, double* x2);
void Dot(int* size, double* a, const double* x, double* y);
void Copy(int* size, const Complex* x, Complex* y);
void Axpy(int* size, Complex* a, const Complex* x, Complex* y);
void Scal1(int* size, Complex* a, Complex* x);
void Scal2(int* size, Complex* a, Complex* b, Complex* c, Complex* d,
           Complex* x1, Complex* x2);
void Dot(int* size, Complex* a, const Complex* x, Complex* y);
#endif

#endif
