#ifndef FOREST_H
#define FOREST_H

#include <iostream.h>
#include <fstream.h>

#include "Array.h"
#include "Permutation.h"
#include "Error.h"

#undef __CLASS__
#define __CLASS__ "Forest"
class Forest
{
  protected:
    int numberOfNodes_;
    int numberOfTrees_;
    int root_;
    Array<int>* parent_;
    Array<int>* firstChild_;
    Array<int>* nextSibling_;

    Forest(const Forest&);
    Forest& operator=(const Forest&);

    void allocate(void);
    void free(void);

  public:
    Forest();
    virtual ~Forest();

    Forest(int numberOfNodes);

    int getNumberOfNodes(void) const
      {return numberOfNodes_;}
    int getNumberOfTrees(void) const
      {return numberOfTrees_;}
    Array<int>* getParent(void)
      {return parent_;}
    const Array<int>* getParent(void) const
      {return parent_;}
    Array<int>* getFirstChild(void)
      {return firstChild_;}
    const Array<int>* getFirstChild(void) const
      {return firstChild_;}
    Array<int>* getNextSibling(void)
      {return nextSibling_;}
    const Array<int>* getNextSibling(void) const
      {return nextSibling_;}

    void resize(int numberOfNodes);
    int getHeapSize(void) const;
    bool check(void) const;

    void print(void) const;

    int getFirstPostorderNode(void) const;
    int getNextPostorderNode(int node) const;
    int getFirstPreorderNode(void) const;
    int getNextPreorderNode(int node) const;
};

#endif
