#ifndef ERROR_H
#define ERROR_H

enum Error {None, MemoryAllocation, FileOpen, InvalidInput,
            Zero1x1Pivot, Zero2x2Pivot, RootDelay,
            EmptyStack, FullStack, EmptyQueue, FullQueue};

#ifndef ERROR_CC
extern Error ErrorCode;
extern char* ErrorMessage[];
#endif

#ifdef TRACE_CALLS
#define BEGIN_FUNCTION() \
{ \
  cout << "CALLED " << __CLASS__ \
       << "::" << __FUNC__ << endl; \
}
#else
#define BEGIN_FUNCTION() \
{ \
}
#endif

#define END_FUNCTION() \
{ \
}

#ifdef TRACE_ERRORS
#define SET_ERROR1(errorCode) \
{ \
  cout << "SET_ERROR1 in " << __CLASS__ << "::" \
       << __FUNC__ << endl; \
  ErrorCode = (errorCode); \
  END_FUNCTION(); \
  return; \
}

#define SET_ERROR2(errorCode, returnValue) \
{ \
  cout << "SET_ERROR2 in " << __CLASS__ << "::" \
       << __FUNC__ << endl; \
  ErrorCode = (errorCode); \
  END_FUNCTION(); \
  return (returnValue); \
}

#define CHECK_ERROR1() \
{ \
  if (ErrorCode != None) \
  { \
    cout << "CHECK_ERROR1 in " << __CLASS__ \
         << "::" << __FUNC__ << endl; \
    END_FUNCTION(); \
    return; \
  } \
}

#define CHECK_ERROR2(returnValue) \
{ \
  if (ErrorCode != None) \
  { \
    cout << "CHECK_ERROR2 in " << __CLASS__ \
         << "::" << __FUNC__ << endl; \
    END_FUNCTION(); \
    return (returnValue); \
  } \
}
#else
#define SET_ERROR1(errorCode) \
{ \
  ErrorCode = (errorCode); \
  END_FUNCTION(); \
  return; \
}

#define SET_ERROR2(errorCode, returnValue) \
{ \
  ErrorCode = (errorCode); \
  END_FUNCTION(); \
  return (returnValue); \
}

#define CHECK_ERROR1() \
{ \
  if (ErrorCode != None) \
  { \
    END_FUNCTION(); \
    return; \
  } \
}

#define CHECK_ERROR2(returnValue) \
{ \
  if (ErrorCode != None) \
  { \
    END_FUNCTION(); \
    return (returnValue); \
  } \
}
#endif

#define CHECK_ERROR3() \
{ \
  if (ErrorCode != None) \
  { \
    cout << "Error encountered in Oblio: " \
         << ErrorMessage[ErrorCode] << "." << endl; \
    return; \
  } \
}

#define CHECK_ERROR4(returnValue) \
{ \
  if (ErrorCode != None) \
  { \
    cout << "Error encountered in Oblio: " \
         << ErrorMessage[ErrorCode] << "." << endl; \
    return (returnValue); \
  } \
}

#define CLEAR_ERROR() \
{ \
  ErrorCode = None; \
}

#endif
