#ifndef ELIMINATION_FOREST_H
#define ELIMINATION_FOREST_H

#include <iostream.h>
#include <fstream.h>

#include "Complex.h"
#include "Array.h"
#include "Forest.h"
#include "SparseMatrix.h"
#include "SparseFactors.h"
#include "Permutation.h"
#include "Error.h"

#undef __CLASS__
#define __CLASS__ "EliminationForest"
class EliminationForest: public Forest
{
  private:
    int order_;
    Array<int>* frontPointer_;
    Array<int>* frontMap_;
    Array<int>* borderSize_;

    EliminationForest(const EliminationForest&);
    EliminationForest& operator=(const EliminationForest&);

    void allocate(void);
    void free(void);

    void initialize(const Array<int>* aColumnPointer,
                    const Array<int>* aRowIndex,
                    Permutation& p);
    void initialize(const Array<int>* lColumnPointer,
                    const Array<int>* lRowIndex);

  public:
    EliminationForest();
    virtual ~EliminationForest();

    EliminationForest(int numberOfNodes);

    int getOrder(void) const
      {return order_;}
    Array<int>* getFrontPointer(void)
      {return frontPointer_;}
    const Array<int>* getFrontPointer(void) const
      {return frontPointer_;}
    Array<int>* getFrontMap(void)
      {return frontMap_;}
    const Array<int>* getFrontMap(void) const
      {return frontMap_;}
    Array<int>* getBorderSize(void)
      {return borderSize_;}
    const Array<int>* getBorderSize(void) const
      {return borderSize_;}

    void resize(int numberOfNodes);
    int getHeapSize(void) const;
    bool check(void) const;

    void print(void) const;
    void save(const char* fileName) const;

    void initialize(const SparseMatrix<double>& a,
                    Permutation& p);
    void initialize(const SparseMatrix<Complex>& a,
                    Permutation& p);
    void initialize(const SparseFactors<double>& l);
    void initialize(const SparseFactors<Complex>& l);
    void compress(void);
    int getNumberOfRowIndices(void) const;
    int getNumberOfOffDiagonals(void) const;
    void getWork(float& eliminationWork,
                 float& assemblyWork,
                 float& solutionWork,
                 double) const;
    void getWork(float& eliminationWork,
                 float& assemblyWork,
                 float& solutionWork,
                 Complex) const;
};

#endif
