#ifndef ARRAY_H
#define ARRAY_H

#include <iostream.h>
#include <fstream.h>

#include "Error.h"

#undef __CLASS__
#define __CLASS__ "Array"
template<class T>
class Array
{
  private:
    int size_;
    T* item_;

    Array(const Array&);
    Array& operator=(const Array&);

    void allocate(void);
    void free(void);

  public:
    Array();
    Array(int size);
    virtual ~Array();

    int getSize(void) const {return size_;}
    void setSize(int size) {size_ = size;}
    T* getItem(void) {return item_;}
    const T* getItem(void) const {return item_;}
    void setItem(T* item) {item_ = item;}

    T getItem(int i) const {return item_[i];}
    void setItem(T item, int i) {item_[i] = item;}

    T& item(int i) const {return item_[i];}

    void resize(int size);
    int getHeapSize(void) const;
    bool check(void) const;

    void print(void) const;
    void load(const char* fileName);
    void save(const char* fileName) const;

    void fill(T item);
    void extend(void);
};

#undef __FUNC__
#define __FUNC__ "allocate"
template<class T>
void Array<T>::allocate(void)
{
  BEGIN_FUNCTION();

  try
  {
    item_ = new T[size_];
  }
  catch (...)
  {
    SET_ERROR1(MemoryAllocation);
  }

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "free"
template<class T>
void Array<T>::free(void)
{
  BEGIN_FUNCTION();

  delete [] item_;
  item_ = 0;

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "Array"
template<class T>
Array<T>::Array():
  size_(0),
  item_(0)
{
  BEGIN_FUNCTION();

  allocate();

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "Array"
template<class T>
Array<T>::Array(int size):
  size_(size),
  item_(0)
{
  BEGIN_FUNCTION();

  allocate();

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "~Array"
template<class T>
Array<T>::~Array()
{
  BEGIN_FUNCTION();

  free();

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "resize"
template<class T>
void Array<T>::resize(int size)
{
  BEGIN_FUNCTION();

  free();
  size_ = size;
  allocate();

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "getHeapSize"
template<class T>
int Array<T>::getHeapSize(void) const
{
  BEGIN_FUNCTION();

  END_FUNCTION();

  return size_ * sizeof(T);
}

#undef __FUNC__
#define __FUNC__ "check"
template<class T>
bool Array<T>::check(void) const
{
  BEGIN_FUNCTION();

  END_FUNCTION();

  if (size_ < 0)
    return false;
  return true;
}

#undef __FUNC__
#define __FUNC__ "print"
template<class T>
void Array<T>::print(void) const
{
  BEGIN_FUNCTION();

  cout << "ARRAY object" << endl
       << "Size: " << size_ << endl;

  cout << "Items:";
  for (int i = 0; i < size_; i++)
    cout << " " << item_[i];
  cout << endl;

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "load"
template<class T>
void Array<T>::load(const char* fileName)
{
  BEGIN_FUNCTION();

  ifstream fin(fileName);
  if (!fin)
    SET_ERROR1(FileOpen);

  int size;
  fin >> size;
  resize(size);
  CHECK_ERROR1();

  for (int i = 0; i < size_; i++)
    fin >> item_[i];

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "save"
template<class T>
void Array<T>::save(const char* fileName) const
{
  BEGIN_FUNCTION();

  ofstream fout(fileName);
  if (!fout)
    SET_ERROR1(FileOpen);

  fout << size_;

  for (int i = 0; i < size_; i++)
    fout << item_[i];
  fout << endl;

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "fill"
template<class T>
void Array<T>::fill(T item)
{
  BEGIN_FUNCTION();

  for (int i = 0; i < size_; i++)
    item_[i] = item;

  END_FUNCTION();
}

#undef __FUNC__
#define __FUNC__ "extend"
template<class T>
void Array<T>::extend(void)
{
  BEGIN_FUNCTION();

  int oldSize = size_;
  T* oldItem = item_;

  size_ *= 2;
  item_ = 0;
  allocate();
  if (ErrorCode != None)
  {
    size_ = oldSize;
    item_ = oldItem;
  }

  for (int i = 0; i < oldSize; i++)
    item_[i] = oldItem[i];

  delete [] oldItem;

  END_FUNCTION();
}

#endif
