#include <iostream.h>
#include <stdlib.h>
#include <new.h>

#include "Complex.h"
#include "SparseMatrix.h"
#include "Error.h"

#define ValueType double

void oblio_new_handler(void)
{
  int i = 0;
  throw i;
}

int main(int argc, char **argv)
{
  if (argc < 3)
  {
    cerr << "usage: rsc input-file output-file storage format values" << endl;
    return 1;
  }

  cerr << "loading ..." << endl;
  SparseMatrix<ValueType> a;
  a.setValued(false);
  a.load(argv[1]);
  CHECK_ERROR4(1);

  if (argc == 3)
  {
    cerr << "saving ..." << endl;
    a.saveNg(argv[2]);
    CHECK_ERROR4(1);
    return 0;
  }

  switch (atoi(argv[3]))
  {
    case 0:
      a.setStorage(Lower);
      break;

    case 1:
      a.setStorage(Upper);
      break;

    default:
      a.setStorage(Square);
      break;
  }

  switch (atoi(argv[4]))
  {
    case 0:
      a.setFormat(Compressed);
      break;

    default:
      a.setFormat(Uncompressed);
      break;
  }

  a.setPrecision(16);
  switch (atoi(argv[5]))
  {
    case 0:
      a.setValued(false);
      break;

    default:
      a.setValued(true);
      break;
 }

  cerr << "saving ..." << endl;
  a.save(argv[2]);
  CHECK_ERROR4(1);

  return 0;
}
