/* INCLUDE FILES */
#include <stdlib.h>
#include "mm.h"

double ** prism_s_m_d_alloc_matrix(int i_rows, int i_cols, char file[],
				   int lineno)

     /* 
	COPYRIGHT U.S. GOVERNMENT 
   
	This software is distributed without charge and comes with no
	warranty.

	Please feel free to send questions, comments, and problem
	reports to prism@super.org.
	*/

     /* PURPOSE
	=======
	Allocate memory for i_rows x i_cols matrix of double using
	malloc.  The function returns the value of <p_name>, which is
	of type double **.  This allows correct referencing of matrix
	elements by standard C 2-dimensional array syntax. Since we
	are interfacing with FORTRAN callable routines, matrix
	elements will be stored in memory by column.  Thus matrix
	elements should be referenced as p_name[col][row].
   NOTE: This routine is normally called by:
         prism_m_d_alloc_matrix(int i_rows, int i_cols)
         and the cpp definitions in mm.h do the name shift and add the
         last two arguments automatically.
	*/

     /* PARAMETERS
	==========
	i_rows:  number of rows in matrix
	i_cols:  number of cols in matrix

	file: string with file name.  usually provided by cpp with "__FILE__".

	lineno: line number of file.  usually provided by cpp with "__LINE__".
	*/
{
  /* --------------- */
  /* Local variables */
  /* --------------- */
  int
    i			      /* loop counter */
      ; 
  double
    ** p_name                 /* pointer to pointer to [0][0] entry */
    ;

  /* global initializations */
  prism_v_init_var();

  /* obtain memory for pointers to columns */
  /* malloc returns pointer to pointers */
  p_name = (double **) malloc((size_t)(i_cols * sizeof(double *)));
  if (p_name == NULL) {
    /* use shifted name because want file and lineno of calling routine */
    prism_s_v_generror("allocation failure 1 in prism_s_m_d_alloc_matrix",
		       brief, file, lineno);
  }

  /* obtain consecutive memory for all matrix entries */
  /* malloc returns pointer to first column */
  p_name[0] = (double *)malloc((size_t)(i_rows * i_cols * sizeof(double)));
  if (p_name[0] == NULL) {
    /* use shifted name because want file and lineno of calling routine */
    prism_s_v_generror("allocation failure 2 in prism_s_m_d_alloc_matrix",
		       brief, file, lineno);
  }

  /* assign pointers for each subsequent column */
  for (i = 1; i < i_cols; i++) {
    p_name[i] = p_name[i-1] + i_rows;
  }

  return p_name;
}
