/* INCLUDE FILES */
#include <stdlib.h>
#include "stdeig.h"
#include "mm.h"

int prism_i_ldwk(int i_v_dim, int i_g_dim, int i_blk_nw, int i_panelwidth,
	    int i_offset, int i_panel_spc, int i_row_blks, int i_sbmsh_rows)

     /* 
	COPYRIGHT U.S. GOVERNMENT 
   
	This software is distributed without charge and comes with no
	warranty.

	Please feel free to send questions, comments, and problem
	reports to prism@super.org.
	*/

     /* PURPOSE
	=======
	This function computes the leading dimension to use for
	storing matrices.  The leading dim is chosen to minimize the
	communication required by BMR
	*/

     /* PARAMETERS
        ==========
	i_v_dim:  virtual dimension used for blocking of matrices
	i_g_dim:  dimension of matrix
	i_blk_nw:  index of matrix block in nw corner of submesh
	i_panelwidth:  panel width for torus wrap
	i_offset:  offset to first panel of torus-wrapped matrix
	i_panel_spc:  number of virtual nodes to step to next contiguous panel
	i_row_blks:  # of blocks of matrix in row dimension
	i_sbmsh_rows:  number of physical nodes in row of submesh
	*/
{
  /* --------------- */
  /* Local variables */
  /* --------------- */
  int
    i_ld,            /* leading dimension of matrix */
    i
      ;

  /* use as small a leading dim as possible */
  for (i = 0, i_ld = 0; i < i_sbmsh_rows; i++) {
    i_ld = MAX(i_ld,
	       prism_i_ldim(i_v_dim, i_g_dim, i_blk_nw,
		      (i_blk_nw + i*i_row_blks)%i_v_dim,
		      (i_blk_nw + (i+1)*i_row_blks - 1)%i_v_dim, i_panelwidth,
		      i_offset, i_panel_spc));
  }

  return i_ld;
}
