/* 
   COPYRIGHT U.S. GOVERNMENT 
   
   This software is distributed without charge and comes with
   no warranty.

   Please feel free to send questions, comments, and problem reports
   to prism@super.org. 
*/

/* PURPOSE
   =======
   This function computes the local multiplication C = (r_mult)C on
   each node. 
   */

/* INCLUDE FILES */
#include "stdeig.h"
#include "mm.h"

void prism_v_scl_mtrx(int i_rows, int i_cols, P_R_MATRIX m_r_a, double r_mult)
{
  /* local variables */
  int
    i,
    j
      ;

  if (r_mult != r_zero) {
    for (j = 0; j < i_cols; j++) {
      for (i = 0; i < i_rows; i++) 
	m_r_a[j][i] = r_mult*m_r_a[j][i];
    }
  }
  else {
    for (j = 0; j < i_cols; j++) {
      for (i = 0; i < i_rows; i++) 
	m_r_a[j][i] = r_zero;
    }
  }
  return;
}










