/* 
   COPYRIGHT U.S. GOVERNMENT 
   
   This software is distributed without charge and comes with
   no warranty.

   Please feel free to send questions, comments, and problem reports
   to prism@super.org. 
*/

/* PURPOSE
   =======
   Header file for testing matrix multiplication codes.
*/

/* safe guard to avoid multiple inclusion of this file */
#if !defined(MM_TEST_H)
#define MM_TEST_H

#include <stdio.h>
/* NOTE: we use <> for include files instead of "" because CPP includes
   the local copy if you use "" and this messes up our development work.
   Even thought this include file is in <> it is not a system file */
#include <mm.h>

/* GLOBAL variables */
int 
  prism_i_kdim               /* used in computing C(i,j) */
     ;
double 
  prism_d_lambda, 
  prism_d_gamma;             /* used in computing A(i,j), B(i,j) */

E_BOOLEAN
  prism_e_transa, prism_e_transb;

/* function prototypes */

/* ---------------------- */
/* Testing routines (BMR) */
/* ---------------------- */
extern void prism_v_error_chk(int i_mdim, int i_ndim_x, int i_v_dim,
			      int i_sbmsh_nw_x, int i_sbmsh_nw_y,
			      int i_sbmsh_rows, int i_sbmsh_cols,
			      int i_r_panelwidth, int i_c_panelwidth,
			      int i_panel_spc,
			      double (* func)(int i, int j),
			      double *p_dst, int i_lda, E_LAYOUT e_layout,
			      int i_2dcomm_rows, int i_2dcomm_cols,
			      int i_2d_row, int i_2d_col);
#endif
