      SUBROUTINE SCHKOP( DOTYPE, NM, MVAL, NN, NVAL,
     $                   THRESH, TSTERR, NMAX, A, AF, AQ, AT, C, D, E,
     $                   TAU, WORK, RWORK, NOUT )
*
*  -- LAPACK test routine --
*     E. Anderson, Cray Research Inc.
*     May 25, 1995
*
*     .. Scalar Arguments ..
      LOGICAL            TSTERR
      INTEGER            NM, NMAX, NN, NOUT
      REAL               THRESH
*     ..
*     .. Array Arguments ..
      LOGICAL            DOTYPE( * )
      INTEGER            MVAL( * ), NVAL( * )
      REAL               A( * ), AF( * ), AQ( * ), AT( * ), C( * ),
     $                   D( * ), E( * ), RWORK( * ), TAU( * ), WORK( * )
*     ..
*
*  Purpose
*  =======
*
*  SCHKOP tests SSPTRD, SOPGTR, and SOPMTR.
*
*  Arguments
*  =========
*
*  DOTYPE  (input) LOGICAL array, dimension (NTYPES)
*          The matrix types to be used for testing.  Matrices of type j
*          (for 1 <= j <= NTYPES) are used for testing if DOTYPE(j) =
*          .TRUE.; if DOTYPE(j) = .FALSE., then type j is not used.
*
*  NM      (input) INTEGER
*          The number of values of M contained in the vector MVAL.
*
*  MVAL    (input) INTEGER array, dimension (NM)
*          The values of the matrix dimension M, used as the size of the
*          symmetric square matrix to be reduced by SSPTRD.
*
*  NN      (input) INTEGER
*          The number of values of N contained in the vector NVAL.
*
*  NVAL    (input) INTEGER array, dimension (NN)
*          The values of the matrix dimension N, used as the other
*          dimension of the matrix C multiplied on the left or right by
*          Q or Q**T.
*
*  THRESH  (input) REAL
*          The threshold value for the test ratios.  A result is
*          included in the output file if RESULT >= THRESH.  To have
*          every test ratio printed, use THRESH = 0.
*
*  TSTERR  (input) LOGICAL
*          Flag that indicates whether error exits are to be tested.
*
*  NMAX    (input) INTEGER
*          The maximum value permitted for M or N, used in dimensioning
*          the work arrays.
*
*  A       (workspace) REAL array, dimension (NMAX*NMAX)
*
*  AF      (workspace) REAL array, dimension (NMAX*NMAX)
*
*  AQ      (workspace) REAL array, dimension (NMAX*NMAX)
*
*  AT      (workspace) REAL array, dimension (NMAX*NMAX)
*
*  C       (workspace) REAL array, dimension (NMAX*NMAX)
*
*  D       (workspace) REAL array, dimension (NMAX)
*
*  E       (workspace) REAL array, dimension (NMAX)
*
*  TAU     (workspace) REAL array, dimension (NMAX)
*
*  WORK    (workspace) REAL array, dimension (NMAX*NMAX)
*
*  RWORK   (workspace) REAL array, dimension (NMAX)
*
*  NOUT    (input) INTEGER
*          The unit number for output.
*
*     .. Parameters ..
      INTEGER            NTESTS, NTYPES
      PARAMETER          ( NTESTS = 6, NTYPES = 1 )
      REAL               ZERO, ONE
      PARAMETER          ( ZERO = 0.0E+0, ONE = 1.0E+0 )
*     ..
*     .. Local Scalars ..
      CHARACTER          OLPU, SIDE, TRANS, UPLO
      CHARACTER*3        PATH
      INTEGER            I, IA, IAF, IM, IMAT, IN, INFO, ISIDE, ITRANS,
     $                   IUPLO, J, LDA, LWORK, M, MC, MODE, N, NC,
     $                   NERRS, NFAIL, NRUN, NT
      REAL               CNORM, COND, EPS, RESID, ROGUE
*     ..
*     .. Local Arrays ..
      INTEGER            ISEED( 4 ), ISEEDY( 4 )
      REAL               RESULT( NTESTS )
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      REAL               SLAMCH, SLANGE
      EXTERNAL           LSAME, SLAMCH, SLANGE
*     ..
*     .. External Subroutines ..
      EXTERNAL           ALAHD, ALASUM, SERRRD, SGEMM, SLACPY, SLAGSY,
     $                   SLARNV, SLASET, SLATM1, SOPGTR, SOPMTR, SSPTRD,
     $                   STRDT1, XLAENV
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MAX, REAL
*     ..
*     .. Scalars in Common ..
      LOGICAL            LERR, OK
      CHARACTER*6        SRNAMT
      INTEGER            INFOT, NUNIT
*     ..
*     .. Common blocks ..
      COMMON             / INFOC / INFOT, NUNIT, OK, LERR
      COMMON             / SRNAMC / SRNAMT
*     ..
*     .. Data statements ..
      DATA               ISEEDY / 0, 0, 0, 1 /
*     ..
*     .. Executable Statements ..
*
*     Initialize constants and the random number seed.
*
      PATH( 1: 1 ) = 'Single precision'
      PATH( 2: 3 ) = 'OP'
      NRUN = 0
      NFAIL = 0
      NERRS = 0
      DO 10 I = 1, 4
         ISEED( I ) = ISEEDY( I )
   10 CONTINUE
*
*     Test the error exits
*
      IF( TSTERR )
     $   CALL SERRRD( PATH, NOUT )
*
*     Print the header if NM = 0 and THRESH = 0.
*
      IF( NM.EQ.0 .AND. THRESH.EQ.ZERO )
     $   CALL ALAHD( NOUT, PATH )
      INFOT = 0
      CALL XLAENV( 2, 2 )
*
      EPS = SLAMCH( 'Epsilon' )
      LDA = NMAX
      LWORK = NMAX*NMAX
*
*     Do for each value of M in MVAL.
*
      DO 110 IM = 1, NM
         M = MVAL( IM )
         DO 100 IMAT = 1, NTYPES
*
*           Do the tests only if DOTYPE( IMAT ) is true.
*
            IF( .NOT.DOTYPE( IMAT ) )
     $         GO TO 100
*
*           Generate a symmetric matrix.
*
            MODE = 3
            COND = 2.0
            CALL SLATM1( MODE, COND, 0, 2, ISEED, D, M, INFO )
            IF( M.GT.0 )
     $         CALL SLAGSY( M, M-1, D, A, LDA, ISEED, WORK, INFO )
*
            DO 90 IUPLO = 1, 2
               IF( IUPLO.EQ.1 ) THEN
                  UPLO = 'Lower'
                  OLPU = 'Upper'
               ELSE
                  UPLO = 'Upper'
                  OLPU = 'Lower'
               END IF
*
*              Copy the matrix A to the array AF.
*
               IA = 1
               IAF = 1
               IF( IUPLO.EQ.1 ) THEN
                  DO 12 J = 1, M
                     CALL SCOPY( M-J+1, A( IA ), 1, AF( IAF ), 1 )
                     IA = IA + LDA + 1
                     IAF = IAF + M - J + 1
   12             CONTINUE
               ELSE
                  DO 14 J = 1, M
                     CALL SCOPY( J, A( IA ), 1, AF( IAF ), 1 )
                     IA = IA + LDA
                     IAF = IAF + J
   14             CONTINUE
               END IF
*
*              Compute the reduction to tridiagonal form in AF.
*
               SRNAMT = 'SSPTRD'
               CALL SSPTRD( UPLO, M, AF, D, E, TAU, INFO )
*
*              Generate the m-by-m matrix Q
*
               CALL SLASET( 'Full', M, M, ROGUE, ROGUE, AQ, LDA )
               SRNAMT = 'SOPGTR'
               CALL SOPGTR( UPLO, M, AF, TAU, AQ, LDA, WORK, INFO )
*
*              Check the factorization and orthogonality of Q.
*
               CALL STRDT1( UPLO, M, A, LDA, AQ, LDA, D, E, AT, LDA,
     $                      WORK, LWORK, RWORK, RESULT )
*
*              Print information about the tests that did not
*              pass the threshold.
*
               DO 20 I = 1, 2
                  IF( RESULT( I ).GE.THRESH ) THEN
                     IF( NFAIL.EQ.0 .AND. NERRS.EQ.0 )
     $                  CALL ALAHD( NOUT, PATH )
                     WRITE( NOUT, FMT = 9999 )UPLO, M, IMAT,
     $                  I, RESULT( I )
                     NFAIL = NFAIL + 1
                  END IF
   20          CONTINUE
               NRUN = NRUN + 2
*
*              Do for each value of N in NVAL.
*
               DO 70 IN = 1, NN
                  N = NVAL( IN )
                  NT = 0
*
*                 Test SOPMTR
*
                  DO 50 ISIDE = 1, 2
                     IF( ISIDE.EQ.1 ) THEN
                        SIDE = 'Left'
                        MC = M
                        NC = N
                     ELSE
                        SIDE = 'Right'
                        MC = N
                        NC = M
                     END IF
*
*                    Generate MC by NC matrix C
*
                     DO 30 J = 1, NC
                        CALL SLARNV( 2, ISEED, MC,
     $                               C( 1+( J-1 )*LDA ) )
   30                CONTINUE
                     CNORM = SLANGE( '1', MC, NC, C, LDA, RWORK )
                     IF( CNORM.EQ.0.0 )
     $                  CNORM = ONE
                     DO 40 ITRANS = 1, 2
                        IF( ITRANS.EQ.1 ) THEN
                           TRANS = 'No transpose'
                        ELSE
                           TRANS = 'Transpose'
                        END IF
*
*                       Copy C
*
                        CALL SLACPY( 'Full', MC, NC, C, LDA, AT, LDA )
*
*                       Apply Q or Q' to C
*
                        SRNAMT = 'SOPMTR'
                        CALL SOPMTR( SIDE, UPLO, TRANS, MC, NC, AF,
     $                               TAU, AT, LDA, WORK, INFO )
*
*                       Form explicit product and subtract
*
                        IF( LSAME( SIDE, 'L' ) ) THEN
                           CALL SGEMM( TRANS, 'No transpose', MC, NC,
     $                                 MC, -ONE, AQ, LDA, C, LDA,
     $                                 ONE, AT, LDA )
                        ELSE
                           CALL SGEMM( 'No transpose', TRANS, MC, NC,
     $                                 NC, -ONE, C, LDA, AQ, LDA,
     $                                 ONE, AT, LDA )
                        END IF
*
*                       Compute error in the difference
*
                        RESID = SLANGE( '1', MC, NC, AT, LDA, RWORK )
                        NT = NT + 1
                        RESULT( NT ) = RESID /
     $                                 ( REAL( MAX( 1, MC ) )*CNORM*
     $                                 EPS )
   40                CONTINUE
   50             CONTINUE
*
*                 Print information about the tests that did not
*                 pass the threshold.
*
                  DO 60 I = 1, NT
                     IF( RESULT( I ).GE.THRESH ) THEN
                        IF( NFAIL.EQ.0 .AND. NERRS.EQ.0 )
     $                     CALL ALAHD( NOUT, PATH )
                        IF( I.LE.2 ) THEN
                           MC = M
                           NC = N
                        ELSE
                           MC = N
                           NC = M
                        END IF
                        WRITE( NOUT, FMT = 9998 )UPLO, MC, NC, IMAT,
     $                     I+2, RESULT( I )
                        NFAIL = NFAIL + 1
                     END IF
   60             CONTINUE
                  NRUN = NRUN + NT
   70          CONTINUE
   90       CONTINUE
  100    CONTINUE
  110 CONTINUE
*
*     Print a summary of the results.
*
      CALL ALASUM( PATH, NOUT, NFAIL, NRUN, NERRS )
*
 9999 FORMAT( ' UPLO=''', A1, ''', N=', I5, ', type ', I2, ', test(',
     $        I2, ')=', G12.5 )
 9998 FORMAT( ' UPLO=''', A1, ''', M=', I5, ', N=', I5, ', type ', I2,
     $        ', test(', I2, ')=', G12.5 )
      RETURN
*
*     End of SCHKOP
*
      END
