      SUBROUTINE DERRRD( PATH, NUNIT )
*
*  -- LAPACK test routine --
*     E. Anderson, Cray Research Inc.
*     May 25, 1995
*
*     .. Scalar Arguments ..
      CHARACTER*3        PATH
      INTEGER            NUNIT
*     ..
*
*  Purpose
*  =======
*
*  DERRRD tests the error exits for the DOUBLE PRECISION reduction
*  routines.
*
*  Arguments
*  =========
*
*  PATH    (input) CHARACTER*3
*          The LAPACK path name for the routines to be tested.
*
*  NUNIT   (input) INTEGER
*          The unit number for output.
*
*  =====================================================================
*
*     .. Parameters ..
      INTEGER            NMAX, LW
      PARAMETER          ( NMAX = 3, LW = ( NMAX+2 )*( NMAX+2 )+NMAX )
*     ..
*     .. Local Scalars ..
      CHARACTER*2        C2
      INTEGER            I, IHI, ILO, INFO, J, NT
*     ..
*     .. Local Arrays ..
      DOUBLE PRECISION   A( NMAX, NMAX ), C( NMAX, NMAX ), D( NMAX ),
     $                   E( NMAX ), S( NMAX ), TAU( NMAX ), TP( NMAX ),
     $                   TQ( NMAX ), W( NMAX ), Z( NMAX, NMAX )
*     ..
*     .. External Functions ..
      LOGICAL            LSAMEN
      EXTERNAL           LSAMEN
*     ..
*     .. External Subroutines ..
      EXTERNAL           ALAESM, CHKXER, DGEBAK, DGEBAL, DGEBRD, DGEHRD,
     $                   DOPGTR, DOPMTR, DORGBR, DORGHR, DORGTR, DORMBR,
     $                   DORMHR, DORMTR, DSPTRD, DSYTRD
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          DBLE
*     ..
*     .. Scalars in Common ..
      LOGICAL            LERR, OK
      CHARACTER*6        SRNAMT
      INTEGER            INFOT, NOUT
*     ..
*     .. Common blocks ..
      COMMON             / INFOC / INFOT, NOUT, OK, LERR
      COMMON             / SRNAMC / SRNAMT
*     ..
*     .. Executable Statements ..
*
      NOUT = NUNIT
      WRITE( NOUT, FMT = * )
      C2 = PATH( 2: 3 )
*
*     Set the variables to innocuous values.
*
      ILO = 1
      IHI = 1
      DO 20 J = 1, NMAX
         DO 10 I = 1, NMAX
            A( I, J ) = 1. / DBLE( I+J )
            C( I, J ) = 0.
   10    CONTINUE
   20 CONTINUE
      DO 30 J = 1, NMAX
         TAU( J ) = 1.
         TP( J ) = 1.
         TQ( J ) = 1.
   30 CONTINUE
      OK = .TRUE.
      NT = 0
*
      IF( LSAMEN( 3, PATH, 'HRD' ) ) THEN
*
*        Test error exits for the reduction to Hessenberg form for
*        the nonsymmetric eigenvalue problem.
*
*        DGEBAL
*
         SRNAMT = 'DGEBAL'
         INFOT = 1
         CALL DGEBAL( '/', 0, A, 1, ILO, IHI, S, INFO )
         CALL CHKXER( 'DGEBAL', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL DGEBAL( 'N', -1, A, 1, ILO, IHI, S, INFO )
         CALL CHKXER( 'DGEBAL', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL DGEBAL( 'N', 2, A, 1, ILO, IHI, S, INFO )
         CALL CHKXER( 'DGEBAL', INFOT, NOUT, LERR, OK )
         NT = NT + 3
*
*        DGEBAK
*
         SRNAMT = 'DGEBAK'
         INFOT = 1
         CALL DGEBAK( '/', 'R', 0, 1, 0, S, 0, A, 1, INFO )
         CALL CHKXER( 'DGEBAK', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL DGEBAK( 'N', '/', 0, 1, 0, S, 0, A, 1, INFO )
         CALL CHKXER( 'DGEBAK', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL DGEBAK( 'N', 'R', -1, 1, 0, S, 0, A, 1, INFO )
         CALL CHKXER( 'DGEBAK', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL DGEBAK( 'N', 'R', 0, 0, 0, S, 0, A, 1, INFO )
         CALL CHKXER( 'DGEBAK', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL DGEBAK( 'N', 'R', 0, 2, 0, S, 0, A, 1, INFO )
         CALL CHKXER( 'DGEBAK', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL DGEBAK( 'N', 'R', 2, 2, 1, S, 0, A, 2, INFO )
         CALL CHKXER( 'DGEBAK', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL DGEBAK( 'N', 'R', 0, 1, 1, S, 0, A, 1, INFO )
         CALL CHKXER( 'DGEBAK', INFOT, NOUT, LERR, OK )
         INFOT = 7
         CALL DGEBAK( 'N', 'R', 0, 1, 0, S, -1, A, 1, INFO )
         CALL CHKXER( 'DGEBAK', INFOT, NOUT, LERR, OK )
         INFOT = 9
         CALL DGEBAK( 'N', 'R', 2, 1, 2, S, 0, A, 1, INFO )
         CALL CHKXER( 'DGEBAK', INFOT, NOUT, LERR, OK )
         NT = NT + 9
*
*        DGEHRD
*
         SRNAMT = 'DGEHRD'
         INFOT = 1
         CALL DGEHRD( -1, 1, 1, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'DGEHRD', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL DGEHRD( 0, 0, 0, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'DGEHRD', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL DGEHRD( 0, 2, 0, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'DGEHRD', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL DGEHRD( 1, 1, 0, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'DGEHRD', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL DGEHRD( 0, 1, 1, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'DGEHRD', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL DGEHRD( 2, 1, 1, A, 1, TAU, W, 2, INFO )
         CALL CHKXER( 'DGEHRD', INFOT, NOUT, LERR, OK )
         INFOT = 8
         CALL DGEHRD( 2, 1, 2, A, 2, TAU, W, 1, INFO )
         CALL CHKXER( 'DGEHRD', INFOT, NOUT, LERR, OK )
         NT = NT + 7
*
*        DORGHR
*
         SRNAMT = 'DORGHR'
         INFOT = 1
         CALL DORGHR( -1, 1, 1, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'DORGHR', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL DORGHR( 0, 0, 0, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'DORGHR', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL DORGHR( 0, 2, 0, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'DORGHR', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL DORGHR( 1, 1, 0, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'DORGHR', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL DORGHR( 0, 1, 1, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'DORGHR', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL DORGHR( 2, 1, 1, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'DORGHR', INFOT, NOUT, LERR, OK )
         INFOT = 8
         CALL DORGHR( 3, 1, 3, A, 3, TAU, W, 1, INFO )
         CALL CHKXER( 'DORGHR', INFOT, NOUT, LERR, OK )
         NT = NT + 7
*
*        DORMHR
*
         SRNAMT = 'DORMHR'
         INFOT = 1
         CALL DORMHR( '/', 'N', 0, 0, 1, 0, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'DORMHR', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL DORMHR( 'L', '/', 0, 0, 1, 0, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'DORMHR', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL DORMHR( 'L', 'N', -1, 0, 1, 0, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'DORMHR', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL DORMHR( 'L', 'N', 0, -1, 1, 0, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'DORMHR', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL DORMHR( 'L', 'N', 0, 0, 0, 0, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'DORMHR', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL DORMHR( 'L', 'N', 0, 0, 2, 0, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'DORMHR', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL DORMHR( 'L', 'N', 1, 2, 2, 1, A, 1, TAU, C, 1, W, 2,
     $                INFO )
         CALL CHKXER( 'DORMHR', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL DORMHR( 'R', 'N', 2, 1, 2, 1, A, 1, TAU, C, 2, W, 2,
     $                INFO )
         CALL CHKXER( 'DORMHR', INFOT, NOUT, LERR, OK )
         INFOT = 6
         CALL DORMHR( 'L', 'N', 1, 1, 1, 0, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'DORMHR', INFOT, NOUT, LERR, OK )
         INFOT = 6
         CALL DORMHR( 'L', 'N', 0, 1, 1, 1, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'DORMHR', INFOT, NOUT, LERR, OK )
         INFOT = 6
         CALL DORMHR( 'R', 'N', 1, 0, 1, 1, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'DORMHR', INFOT, NOUT, LERR, OK )
         INFOT = 8
         CALL DORMHR( 'L', 'N', 2, 1, 1, 1, A, 1, TAU, C, 2, W, 1,
     $                INFO )
         CALL CHKXER( 'DORMHR', INFOT, NOUT, LERR, OK )
         INFOT = 8
         CALL DORMHR( 'R', 'N', 1, 2, 1, 1, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'DORMHR', INFOT, NOUT, LERR, OK )
         INFOT = 11
         CALL DORMHR( 'L', 'N', 2, 1, 1, 1, A, 2, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'DORMHR', INFOT, NOUT, LERR, OK )
         INFOT = 13
         CALL DORMHR( 'L', 'N', 1, 2, 1, 1, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'DORMHR', INFOT, NOUT, LERR, OK )
         INFOT = 13
         CALL DORMHR( 'R', 'N', 2, 1, 1, 1, A, 1, TAU, C, 2, W, 1,
     $                INFO )
         CALL CHKXER( 'DORMHR', INFOT, NOUT, LERR, OK )
         NT = NT + 16
*
      ELSE IF( LSAMEN( 3, PATH, 'TRD' ) ) THEN
*
*        Test error exits for the reductions to tridiagonal form
*        for the symmetric eigenvalue problem.
*
*        DSYTRD
*
         SRNAMT = 'DSYTRD'
         INFOT = 1
         CALL DSYTRD( '/', 0, A, 1, D, E, TAU, W, 1, INFO )
         CALL CHKXER( 'DSYTRD', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL DSYTRD( 'U', -1, A, 1, D, E, TAU, W, 1, INFO )
         CALL CHKXER( 'DSYTRD', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL DSYTRD( 'U', 2, A, 1, D, E, TAU, W, 1, INFO )
         CALL CHKXER( 'DSYTRD', INFOT, NOUT, LERR, OK )
         NT = NT + 3
*
*        DORGTR
*
         SRNAMT = 'DORGTR'
         INFOT = 1
         CALL DORGTR( '/', 0, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'DORGTR', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL DORGTR( 'U', -1, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'DORGTR', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL DORGTR( 'U', 2, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'DORGTR', INFOT, NOUT, LERR, OK )
         INFOT = 7
         CALL DORGTR( 'U', 3, A, 3, TAU, W, 1, INFO )
         CALL CHKXER( 'DORGTR', INFOT, NOUT, LERR, OK )
         NT = NT + 4
*
*        DORMTR
*
         SRNAMT = 'DORMTR'
         INFOT = 1
         CALL DORMTR( '/', 'U', 'N', 0, 0, A, 1, TAU, C, 1, W, 1, INFO )
         CALL CHKXER( 'DORMTR', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL DORMTR( 'L', '/', 'N', 0, 0, A, 1, TAU, C, 1, W, 1, INFO )
         CALL CHKXER( 'DORMTR', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL DORMTR( 'L', 'U', '/', 0, 0, A, 1, TAU, C, 1, W, 1, INFO )
         CALL CHKXER( 'DORMTR', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL DORMTR( 'L', 'U', 'N', -1, 0, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'DORMTR', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL DORMTR( 'L', 'U', 'N', 0, -1, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'DORMTR', INFOT, NOUT, LERR, OK )
         INFOT = 7
         CALL DORMTR( 'L', 'U', 'N', 2, 0, A, 1, TAU, C, 2, W, 1, INFO )
         CALL CHKXER( 'DORMTR', INFOT, NOUT, LERR, OK )
         INFOT = 7
         CALL DORMTR( 'R', 'U', 'N', 0, 2, A, 1, TAU, C, 1, W, 1, INFO )
         CALL CHKXER( 'DORMTR', INFOT, NOUT, LERR, OK )
         INFOT = 10
         CALL DORMTR( 'L', 'U', 'N', 2, 0, A, 2, TAU, C, 1, W, 1, INFO )
         CALL CHKXER( 'DORMTR', INFOT, NOUT, LERR, OK )
         INFOT = 12
         CALL DORMTR( 'L', 'U', 'N', 0, 2, A, 1, TAU, C, 1, W, 1, INFO )
         CALL CHKXER( 'DORMTR', INFOT, NOUT, LERR, OK )
         INFOT = 12
         CALL DORMTR( 'R', 'U', 'N', 2, 0, A, 1, TAU, C, 2, W, 1, INFO )
         CALL CHKXER( 'DORMTR', INFOT, NOUT, LERR, OK )
         NT = NT + 10
*
      ELSE IF( LSAMEN( 2, C2, 'OP' ) ) THEN
*
*        Test error exits for the reductions to tridiagonal form
*        of a symmetric packed matrix.
*
*        DSPTRD
*
         SRNAMT = 'DSPTRD'
         INFOT = 1
         CALL DSPTRD( '/', 0, A, D, E, TAU, INFO )
         CALL CHKXER( 'DSPTRD', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL DSPTRD( 'U', -1, A, D, E, TAU, INFO )
         CALL CHKXER( 'DSPTRD', INFOT, NOUT, LERR, OK )
         NT = NT + 2
*
*        DOPGTR
*
         SRNAMT = 'DOPGTR'
         INFOT = 1
         CALL DOPGTR( '/', 0, A, TAU, Z, 1, W, INFO )
         CALL CHKXER( 'DOPGTR', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL DOPGTR( 'U', -1, A, TAU, Z, 1, W, INFO )
         CALL CHKXER( 'DOPGTR', INFOT, NOUT, LERR, OK )
         INFOT = 6
         CALL DOPGTR( 'U', 2, A, TAU, Z, 1, W, INFO )
         CALL CHKXER( 'DOPGTR', INFOT, NOUT, LERR, OK )
         NT = NT + 3
*
*        DOPMTR
*
         SRNAMT = 'DOPMTR'
         INFOT = 1
         CALL DOPMTR( '/', 'U', 'N', 0, 0, A, TAU, C, 1, W, INFO )
         CALL CHKXER( 'DOPMTR', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL DOPMTR( 'L', '/', 'N', 0, 0, A, TAU, C, 1, W, INFO )
         CALL CHKXER( 'DOPMTR', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL DOPMTR( 'L', 'U', '/', 0, 0, A, TAU, C, 1, W, INFO )
         CALL CHKXER( 'DOPMTR', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL DOPMTR( 'L', 'U', 'N', -1, 0, A, TAU, C, 1, W, INFO )
         CALL CHKXER( 'DOPMTR', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL DOPMTR( 'L', 'U', 'N', 0, -1, A, TAU, C, 1, W, INFO )
         CALL CHKXER( 'DOPMTR', INFOT, NOUT, LERR, OK )
         INFOT = 9
         CALL DOPMTR( 'L', 'U', 'N', 2, 0, A, TAU, C, 1, W, INFO )
         CALL CHKXER( 'DOPMTR', INFOT, NOUT, LERR, OK )
         NT = NT + 6
*
      ELSE IF( LSAMEN( 3, PATH, 'BRD' ) ) THEN
*
*        DGEBRD
*
         SRNAMT = 'DGEBRD'
         INFOT = 1
         CALL DGEBRD( -1, 0, A, 1, D, E, TQ, TP, W, 1, INFO )
         CALL CHKXER( 'DGEBRD', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL DGEBRD( 0, -1, A, 1, D, E, TQ, TP, W, 1, INFO )
         CALL CHKXER( 'DGEBRD', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL DGEBRD( 2, 1, A, 1, D, E, TQ, TP, W, 2, INFO )
         CALL CHKXER( 'DGEBRD', INFOT, NOUT, LERR, OK )
         INFOT = 10
         CALL DGEBRD( 2, 1, A, 2, D, E, TQ, TP, W, 1, INFO )
         CALL CHKXER( 'DGEBRD', INFOT, NOUT, LERR, OK )
         NT = NT + 4
*
*        DORGBR
*
         SRNAMT = 'DORGBR'
         INFOT = 1
         CALL DORGBR( '/', 0, 0, 0, A, 1, TQ, W, 1, INFO )
         CALL CHKXER( 'DORGBR', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL DORGBR( 'Q', -1, 0, 0, A, 1, TQ, W, 1, INFO )
         CALL CHKXER( 'DORGBR', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL DORGBR( 'Q', 0, -1, 0, A, 1, TQ, W, 1, INFO )
         CALL CHKXER( 'DORGBR', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL DORGBR( 'Q', 0, 1, 0, A, 1, TQ, W, 1, INFO )
         CALL CHKXER( 'DORGBR', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL DORGBR( 'Q', 1, 0, 1, A, 1, TQ, W, 1, INFO )
         CALL CHKXER( 'DORGBR', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL DORGBR( 'P', 1, 0, 0, A, 1, TQ, W, 1, INFO )
         CALL CHKXER( 'DORGBR', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL DORGBR( 'P', 0, 1, 1, A, 1, TQ, W, 1, INFO )
         CALL CHKXER( 'DORGBR', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL DORGBR( 'Q', 0, 0, -1, A, 1, TQ, W, 1, INFO )
         CALL CHKXER( 'DORGBR', INFOT, NOUT, LERR, OK )
         INFOT = 6
         CALL DORGBR( 'Q', 2, 1, 1, A, 1, TQ, W, 1, INFO )
         CALL CHKXER( 'DORGBR', INFOT, NOUT, LERR, OK )
         INFOT = 9
         CALL DORGBR( 'Q', 2, 2, 1, A, 2, TQ, W, 1, INFO )
         CALL CHKXER( 'DORGBR', INFOT, NOUT, LERR, OK )
         NT = NT + 10
*
*        DORMBR
*
         SRNAMT = 'DORMBR'
         INFOT = 1
         CALL DORMBR( '/', 'L', 'T', 0, 0, 0, A, 1, TQ, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'DORMBR', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL DORMBR( 'Q', '/', 'T', 0, 0, 0, A, 1, TQ, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'DORMBR', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL DORMBR( 'Q', 'L', '/', 0, 0, 0, A, 1, TQ, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'DORMBR', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL DORMBR( 'Q', 'L', 'T', -1, 0, 0, A, 1, TQ, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'DORMBR', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL DORMBR( 'Q', 'L', 'T', 0, -1, 0, A, 1, TQ, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'DORMBR', INFOT, NOUT, LERR, OK )
         INFOT = 6
         CALL DORMBR( 'Q', 'L', 'T', 0, 0, -1, A, 1, TQ, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'DORMBR', INFOT, NOUT, LERR, OK )
         INFOT = 8
         CALL DORMBR( 'Q', 'L', 'T', 2, 0, 0, A, 1, TQ, C, 2, W, 1,
     $                INFO )
         CALL CHKXER( 'DORMBR', INFOT, NOUT, LERR, OK )
         INFOT = 8
         CALL DORMBR( 'Q', 'R', 'T', 0, 2, 0, A, 1, TQ, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'DORMBR', INFOT, NOUT, LERR, OK )
         INFOT = 8
         CALL DORMBR( 'P', 'L', 'T', 2, 0, 2, A, 1, TQ, C, 2, W, 1,
     $                INFO )
         CALL CHKXER( 'DORMBR', INFOT, NOUT, LERR, OK )
         INFOT = 8
         CALL DORMBR( 'P', 'R', 'T', 0, 2, 2, A, 1, TQ, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'DORMBR', INFOT, NOUT, LERR, OK )
         INFOT = 11
         CALL DORMBR( 'Q', 'R', 'T', 2, 0, 0, A, 1, TQ, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'DORMBR', INFOT, NOUT, LERR, OK )
         INFOT = 13
         CALL DORMBR( 'Q', 'L', 'T', 0, 2, 0, A, 1, TQ, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'DORMBR', INFOT, NOUT, LERR, OK )
         INFOT = 13
         CALL DORMBR( 'Q', 'R', 'T', 2, 0, 0, A, 1, TQ, C, 2, W, 1,
     $                INFO )
         CALL CHKXER( 'DORMBR', INFOT, NOUT, LERR, OK )
         NT = NT + 13
      END IF
*
*     Print a summary line.
*
      CALL ALAESM( PATH, OK, NOUT )
*
      RETURN
*
*     End of DERRRD
*
      END
