      SUBROUTINE DBRDT1( M, N, A, LDA, Q, LDQ, D, E, PT, LDPT, T, LDT,
     $                   WORK, LWORK, RWORK, RESULT )
*
*  -- LAPACK test routine --
*     E. Anderson, Cray Research Inc.
*     May 25, 1995
*     12-1-99:  Change calls to DORT01 to DORGT1  (eca)
*
*     .. Scalar Arguments ..
      INTEGER            LDA, LDPT, LDQ, LDT, LWORK, M, N
*     ..
*     .. Array Arguments ..
      DOUBLE PRECISION   A( LDA, * ), D( * ), E( * ), PT( LDPT, * ),
     $                   Q( LDQ, * ), RESULT( * ), RWORK( * ),
     $                   T( LDT, * ), WORK( LWORK )
*     ..
*
*  Purpose
*  =======
*
*  DBRDT1 tests the reduction to bidiagonal form of an m-by-n matrix A
*  as computed by SGEBRD, and the generation of the orthogonal matrices
*  from the reduction as computed by DORGBR.
*
*  Given A, the diagonal D and offdiagonal E from the bidiagonal form,
*  and the orthogonal matrices Q and PT (= P'), DBRDT1 compares the
*  bidiagonal matrix with Q'*A*P, and checks that the columns of Q and
*  the rows of PT are orthonormal.
*
*  Arguments
*  =========
*
*  M       (input) INTEGER
*          The number of rows of the matrices A and Q.
*
*  N       (input) INTEGER
*          The number of columns of the matrices A and P'.
*
*  A       (input) DOUBLE PRECISION array, dimension (LDA,N)
*          The initial m-by-n matrix A.
*
*  LDA     (input) INTEGER
*          The leading dimension of the array A.
*
*  Q       (input) DOUBLE PRECISION array, dimension (LDQ,N)
*          The m-by-min(m,n) orthogonal matrix Q, as returned by DORGBR
*          with VECT = 'Q'.
*
*  LDQ     (input) INTEGER
*          The leading dimension of the array Q.
*
*  D       (input) DOUBLE PRECISION array, dimension (min(M,N))
*          The diagonal elements of the bidiagonal matrix B.
*
*  E       (input) DOUBLE PRECISION array, dimension (min(M,N)-1)
*          The superdiagonal elements of the bidiagonal matrix B if
*          m >= n, or the subdiagonal elements of B if m < n.
*
*  PT      (input) DOUBLE PRECISION array, dimension (LDPT,N)
*          The min(m,n)-by-n orthogonal matrix P', as returned by
*          DORGBR with VECT = 'P'.
*
*  LDPT    (input) INTEGER
*          The leading dimension of the array PT.
*
*  T       (workspace) DOUBLE PRECISION array, dimension (LDT,min(M,N))
*
*  LDT     (input) INTEGER
*          The leading dimension of the array T.
*
*  WORK    (workspace) DOUBLE PRECISION array, dimension (LWORK)
*
*  LWORK   (input) INTEGER
*          The length of WORK.  Assumed to be at least M*min(M,N).
*
*  RWORK   (workspace) DOUBLE PRECISION array, dimension (N)
*
*  RESULT  (output) DOUBLE PRECISION array, dimension (3)
*          The test ratios:
*          RESULT(1) = norm( B - Q'*A*P ) / ( min(M,N) * norm(A) * EPS )
*          RESULT(2) = norm( I - Q'*Q ) / ( M * EPS )
*          RESULT(3) = norm( I - PT*PT' ) / ( N * EPS )
*
*  =====================================================================
*
*     .. Parameters ..
      DOUBLE PRECISION   ZERO, ONE
      PARAMETER          ( ZERO = 0.0D+0, ONE = 1.0D+0 )
*     ..
*     .. Local Scalars ..
      INTEGER            I, LDWORK, MINMN
      DOUBLE PRECISION   ANORM, EPS, RESID
*     ..
*     .. External Functions ..
      DOUBLE PRECISION   DLAMCH, DLANGE
      EXTERNAL           DLAMCH, DLANGE
*     ..
*     .. External Subroutines ..
      EXTERNAL           DGEMM, DORGT1
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MAX, MIN, DBLE
*     ..
*     .. Executable Statements ..
*
*     Compute A * P
*
      MINMN = MIN( M, N )
      LDWORK = MAX( 1, M )
      CALL DGEMM( 'No transpose', 'Transpose', M, MINMN, N, ONE, A, LDA,
     $            PT, LDPT, ZERO, WORK, LDWORK )
*
*     Compute Q' * (A * P)
*
      CALL DGEMM( 'Transpose', 'No transpose', MINMN, MINMN, M, ONE, Q,
     $            LDQ, WORK, LDWORK, ZERO, T, LDT )
*
*     Subtract the bidiagonal matrix.
*
      T( 1, 1 ) = T( 1, 1 ) - D( 1 )
      IF( M.GE.N ) THEN
         DO 10 I = 2, MINMN
            T( I-1, I ) = T( I-1, I ) - E( I-1 )
            T( I, I ) = T( I, I ) - D( I )
   10    CONTINUE
      ELSE
         DO 20 I = 2, MINMN
            T( I, I-1 ) = T( I, I-1 ) - E( I-1 )
            T( I, I ) = T( I, I ) - D( I )
   20    CONTINUE
      END IF
*
*     Compute norm( T - Q'*A*P ) / ( min(M,N) * norm(A) * EPS ) .
*
      EPS = DLAMCH( 'Epsilon' )
      ANORM = DLANGE( '1', M, N, A, LDA, RWORK )
      RESID = DLANGE( '1', MINMN, MINMN, T, LDT, RWORK )
      IF( ANORM.GT.ZERO ) THEN
         RESULT( 1 ) = ( ( RESID / DBLE( MINMN ) ) / ANORM ) / EPS
      ELSE
         RESULT( 1 ) = ZERO
      END IF
*
*     Compute norm( I - Q'*Q ) / ( M * EPS ) .
*
      CALL DORGT1( 'Columns', M, MINMN, Q, LDQ, WORK, LWORK, RWORK,
     $             RESULT( 2 ) )
*
*     Compute norm( I - PT*PT' ) / ( N * EPS ) .
*
      CALL DORGT1( 'Rows', MINMN, N, PT, LDPT, WORK, LWORK, RWORK,
     $             RESULT( 3 ) )
      RETURN
*
*     End of DBRDT1
*
      END
