      SUBROUTINE CCKHRD( DOTYPE, NM, MVAL, NN, NVAL, NNB, NBVAL, NXVAL,
     $                   THRESH, TSTERR, NMAX, A, AF, AQ, AH, C, TAU, X,
     $                   WORK, RWORK, NOUT )
*
*  -- LAPACK test routine --
*     E. Anderson, Cray Research Inc.
*     May 25, 1995
*
*     .. Scalar Arguments ..
      LOGICAL            TSTERR
      INTEGER            NM, NMAX, NN, NNB, NOUT
      REAL               THRESH
*     ..
*     .. Array Arguments ..
      LOGICAL            DOTYPE( * )
      INTEGER            MVAL( * ), NBVAL( * ), NVAL( * ), NXVAL( * )
      REAL               RWORK( * )
      COMPLEX            A( NMAX, * ), AF( * ), AH( * ), AQ( * ),
     $                   C( * ), TAU( * ), WORK( * ), X( * )
*     ..
*
*  Purpose
*  =======
*
*  CCKHRD tests CGEHRD, CUNGHR and CUNMHR.
*
*  Arguments
*  =========
*
*  DOTYPE  (input) LOGICAL array, dimension (NTYPES)
*          The matrix types to be used for testing.  Matrices of type j
*          (for 1 <= j <= NTYPES) are used for testing if DOTYPE(j) =
*          .TRUE.; if DOTYPE(j) = .FALSE., then type j is not used.
*
*  NM      (input) INTEGER
*          The number of values of M contained in the vector MVAL.
*
*  MVAL    (input) INTEGER array, dimension (NM)
*          The values of the matrix dimension M, used as the size of the
*          nonsymmetric square matrix to be reduced by CGEHRD.
*
*  NN      (input) INTEGER
*          The number of values of N contained in the vector NVAL.
*
*  NVAL    (input) INTEGER array, dimension (NN)
*          The values of the matrix dimension N, used as the other
*          dimension of the matrix C multiplied on the left or right by
*          Q or Q**T.
*
*  NNB     (input) INTEGER
*          The number of values of NB and NX contained in the
*          vectors NBVAL and NXVAL.  The blocking parameters are used
*          in pairs (NB,NX).
*
*  NBVAL   (input) INTEGER array, dimension (NNB)
*          The values of the blocksize NB.
*
*  NXVAL   (input) INTEGER array, dimension (NNB)
*          The values of the crossover point NX.
*
*  THRESH  (input) REAL
*          The threshold value for the test ratios.  A result is
*          included in the output file if RESULT >= THRESH.  To have
*          every test ratio printed, use THRESH = 0.
*
*  TSTERR  (input) LOGICAL
*          Flag that indicates whether error exits are to be tested.
*
*  NMAX    (input) INTEGER
*          The maximum value permitted for M or N, used in dimensioning
*          the work arrays.
*
*  A       (workspace) COMPLEX array, dimension (NMAX*NMAX)
*
*  AF      (workspace) COMPLEX array, dimension (NMAX*NMAX)
*
*  AQ      (workspace) COMPLEX array, dimension (NMAX*NMAX)
*
*  AH      (workspace) COMPLEX array, dimension (NMAX*NMAX)
*
*  C       (workspace) COMPLEX array, dimension (NMAX*NMAX)
*
*  TAU     (workspace) COMPLEX array, dimension (NMAX)
*
*  X       (workspace) COMPLEX array, dimension (NMAX)
*
*  WORK    (workspace) COMPLEX array, dimension (NMAX*NMAX)
*
*  RWORK   (workspace) REAL array, dimension (NMAX)
*
*  NOUT    (input) INTEGER
*          The unit number for output.
*
*     .. Parameters ..
      INTEGER            NTESTS, NTYPES
      PARAMETER          ( NTESTS = 6, NTYPES = 1 )
      COMPLEX            ZERO, ONE
      PARAMETER          ( ZERO = 0.0E+0, ONE = 1.0E+0 )
      COMPLEX            ROGUE
      PARAMETER          ( ROGUE = ( -1.0E+10, -1.0E+10 ) )
*     ..
*     .. Local Scalars ..
      CHARACTER          SIDE, TRANS
      CHARACTER*3        PATH
      INTEGER            I, IHI, IK, ILO, IM, IMAT, IN, INB, INFO,
     $                   ISIDE, ITRANS, J, K, LDA, LWORK, M, MC, MODE,
     $                   N, NB, NC, NERRS, NFAIL, NK, NR, NRUN, NT, NX
      REAL               CNORM, COND, EPS, RESID
*     ..
*     .. Local Arrays ..
      INTEGER            ISEED( 4 ), ISEEDY( 4 )
      REAL               RESULT( NTESTS )
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      REAL               SLAMCH, CLANGE
      EXTERNAL           LSAME, SLAMCH, CLANGE
*     ..
*     .. External Subroutines ..
      EXTERNAL           ALAHD, ALASUM, CCOPY, CERRRD, CGEHRD, CGEMM,
     $                   CHRDT1, CLACPY, CLARF, CLARFG, CLARNV, CLASET,
     $                   CLATM1, CUNGHR, CUNMHR, XLAENV
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MAX, REAL
*     ..
*     .. Scalars in Common ..
      LOGICAL            LERR, OK
      CHARACTER*6        SRNAMT
      INTEGER            INFOT, NUNIT
*     ..
*     .. Common blocks ..
      COMMON             / INFOC / INFOT, NUNIT, OK, LERR
      COMMON             / SRNAMC / SRNAMT
*     ..
*     .. Data statements ..
      DATA               ISEEDY / 0, 0, 0, 1 /
*     ..
*     .. Executable Statements ..
*
*     Initialize constants and the random number seed.
*
      PATH( 1: 3 ) = 'HRD'
      NRUN = 0
      NFAIL = 0
      NERRS = 0
      DO 10 I = 1, 4
         ISEED( I ) = ISEEDY( I )
   10 CONTINUE
*
*     Test the error exits
*
      IF( TSTERR )
     $   CALL CERRRD( PATH, NOUT )
*
*     Print the header if NM = 0 and THRESH = 0.
*
      IF( NM.EQ.0 .AND. THRESH.EQ.0.0 )
     $   CALL ALAHD( NOUT, PATH )
      INFOT = 0
      CALL XLAENV( 2, 2 )
*
      EPS = SLAMCH( 'Epsilon' )
      LDA = NMAX
      LWORK = NMAX*NMAX
*
*     Do for each value of M in MVAL.
*
      DO 140 IM = 1, NM
         M = MVAL( IM )
         DO 130 IMAT = 1, NTYPES
*
*           Do the tests only if DOTYPE( IMAT ) is true.
*
            IF( .NOT.DOTYPE( IMAT ) )
     $         GO TO 130
*
            IF( M.LE.1 ) THEN
               NK = 1
            ELSE IF( M.EQ.2 ) THEN
               NK = 3
            ELSE IF( M.LE.4 ) THEN
               NK = 5
            ELSE
               NK = 6
            END IF
*
*           Do for each combination of ILO and IHI.
*
            DO 120 IK = 1, NK
               K = ( M+1 ) / 2
               IF( IK.EQ.1 ) THEN
                  ILO = 1
                  IHI = M
               ELSE IF( IK.EQ.2 ) THEN
                  ILO = 1
                  IHI = K
               ELSE IF( IK.EQ.3 ) THEN
                  ILO = K + 1
                  IHI = M
               ELSE IF( IK.EQ.4 ) THEN
                  ILO = K
                  IHI = K
               ELSE IF( IK.EQ.5 ) THEN
                  ILO = K
                  IHI = K + 1
               ELSE
                  ILO = 2
                  IHI = M - 1
               END IF
*
*              Generate a Schur matrix of the desired type.
*
               MODE = 3
               COND = 2.0
               CALL CLATM1( MODE, COND, 0, 2, ISEED, X, M, INFO )
               CALL CLASET( 'Full', M, M, ZERO, ZERO, A, LDA )
               CALL CCOPY( M, X, 1, A, LDA+1 )
*
*              Set up complex conjugate pairs
*
CECA           IF( ILO.LT.IHI ) THEN
CECA              A( ILO, ILO+1 ) = A( ILO+1, ILO+1 )
CECA              A( ILO+1, ILO ) = -A( ILO+1, ILO+1 )
CECA              A( ILO+1, ILO+1 ) = A( ILO, ILO )
CECA           END IF
CECA           IF( IHI.GT.ILO+2 ) THEN
CECA              A( IHI-1, IHI ) = A( IHI, IHI )
CECA              A( IHI, IHI-1 ) = -A( IHI, IHI )
CECA              A( IHI, IHI ) = A( IHI-1, IHI-1 )
CECA           END IF
CECA           CALL CLARNV( 1, ISEED, ( IHI-ILO ) / 2, X )
CECA           DO 20 I = ILO + 2, IHI - 3, 2
CECA              IF( X( ( I-ILO ) / 2 ).GT.0.5 ) THEN
CECA                 A( I, I+1 ) = A( I+1, I+1 )
CECA                 A( I+1, I ) = -A( I+1, I+1 )
CECA                 A( I+1, I+1 ) = A( I, I )
CECA              END IF
CECA0          CONTINUE
*
*              Fill the rest of the upper triangle with random elements
*
               DO 30 J = 2, M
                  NR = J - 1
                  IF( A( J-1, J ).NE.ZERO )
     $               NR = J - 2
                  CALL CLARNV( 2, ISEED, NR, A( 1, J ) )
   30          CONTINUE
*
*              Pre- and post-multiply by random orthogonal matrices.
*
               DO 40 I = IHI - 1, ILO, -1
*
*                 Generate random reflection
*
                  CALL CLARNV( 2, ISEED, IHI-I+1, X )
                  CALL CLARFG( IHI-I+1, X( 1 ), X( 2 ), 1, TAU )
                  X( 1 ) = ONE
                  K = I
                  IF( I.GT.1 ) THEN
                     IF( A( I, I-1 ).NE.ZERO )
     $                  K = I - 1
                  END IF
*
*                 Multiply A(i:ihi,i:m) by random reflection from the
*                 left
*
                  CALL CLARF( 'Left', IHI-I+1, M-K+1, X, 1, TAU,
     $                        A( I, K ), LDA, WORK )
                  K = I
                  IF( I.GT.1 ) THEN
                     IF( A( I-1, I ).NE.ZERO )
     $                  K = I - 1
                  END IF
*
*                 Multiply A(1:ihi,i:ihi) by the same reflection from
*                 the right
*
                  CALL CLARF( 'Right', IHI, IHI-I+1, X, 1, TAU,
     $                        A( 1, I ), LDA, WORK )
   40          CONTINUE
*
*              Do for each pair of values (NB,NX) in NBVAL and NXVAL.
*
               DO 110 INB = 1, NNB
                  NB = NBVAL( INB )
                  CALL XLAENV( 1, NB )
                  NX = NXVAL( INB )
                  CALL XLAENV( 3, NX )
*
*                 Copy the matrix A to the array AF.
*
                  CALL CLACPY( 'Full', M, M, A, LDA, AF, LDA )
*
*                 Compute the reduction to Hessenberg form in AF.
*
                  SRNAMT = 'CGEHRD'
                  CALL CGEHRD( M, ILO, IHI, AF, LDA, TAU, WORK, LWORK,
     $                         INFO )
*
*                 Copy details of Q
*
                  CALL CLASET( 'Full', M, M, ROGUE, ROGUE, AQ, LDA )
                  CALL CLACPY( 'Lower', IHI-ILO-1, IHI-ILO-1,
     $                         AF( ( ILO-1 )*LDA+ILO+2 ), LDA,
     $                         AQ( ( ILO-1 )*LDA+ILO+2 ), LDA )
*
*                 Generate the m-by-m matrix Q
*
                  SRNAMT = 'CUNGHR'
                  CALL CUNGHR( M, ILO, IHI, AQ, LDA, TAU, WORK, LWORK,
     $                         INFO )
*
*                 Check the factorization and orthogonality of Q.
*
                  CALL CHRDT1( M, ILO, IHI, A, LDA, AF, LDA, AQ, LDA,
     $                         AH, LDA, WORK, LWORK, RWORK, RESULT )
*
*                 Print information about the tests that did not
*                 pass the threshold.
*
                  DO 50 I = 1, 2
                     IF( RESULT( I ).GE.THRESH ) THEN
                        IF( NFAIL.EQ.0 .AND. NERRS.EQ.0 )
     $                     CALL ALAHD( NOUT, PATH )
                        WRITE( NOUT, FMT = 9999 )M, ILO, IHI, NB, NX,
     $                     IMAT, I, RESULT( I )
                        NFAIL = NFAIL + 1
                     END IF
   50             CONTINUE
                  NRUN = NRUN + 2
*
*                 Do for each value of N in NVAL.
*
                  DO 100 IN = 1, NN
                     N = NVAL( IN )
                     NT = 0
*
*                    Test CUNMHR
*
                     DO 80 ISIDE = 1, 2
                        IF( ISIDE.EQ.1 ) THEN
                           SIDE = 'Left'
                           MC = M
                           NC = N
                        ELSE
                           SIDE = 'Right'
                           MC = N
                           NC = M
                        END IF
*
*                       Generate MC by NC matrix C
*
                        DO 60 J = 1, NC
                           CALL CLARNV( 2, ISEED, MC,
     $                                  C( 1+( J-1 )*LDA ) )
   60                   CONTINUE
                        CNORM = CLANGE( '1', MC, NC, C, LDA, RWORK )
                        IF( CNORM.EQ.0.0 )
     $                     CNORM = 1.0
                        DO 70 ITRANS = 1, 2
                           IF( ITRANS.EQ.1 ) THEN
                              TRANS = 'No transpose'
                           ELSE
                              TRANS = 'Conjugate transpose'
                           END IF
*
*                          Copy C
*
                           CALL CLACPY( 'Full', MC, NC, C, LDA, AH,
     $                                  LDA )
*
*                          Apply Q or Q' to C
*
                           SRNAMT = 'CUNMHR'
                           CALL CUNMHR( SIDE, TRANS, MC, NC, ILO, IHI,
     $                                  AF, LDA, TAU, AH, LDA, WORK,
     $                                  LWORK, INFO )
*
*                          Form explicit product and subtract
*
                           IF( LSAME( SIDE, 'L' ) ) THEN
                              CALL CGEMM( TRANS, 'No transpose', MC, NC,
     $                                    MC, -ONE, AQ, LDA, C, LDA,
     $                                    ONE, AH, LDA )
                           ELSE
                              CALL CGEMM( 'No transpose', TRANS, MC, NC,
     $                                    NC, -ONE, C, LDA, AQ, LDA,
     $                                    ONE, AH, LDA )
                           END IF
*
*                          Compute error in the difference
*
                           RESID = CLANGE( '1', MC, NC, AH, LDA, RWORK )
                           NT = NT + 1
                           RESULT( NT ) = RESID /
     $                                    ( REAL( MAX( 1, MC ) )*CNORM*
     $                                    EPS )
   70                   CONTINUE
   80                CONTINUE
*
*                    Print information about the tests that did not
*                    pass the threshold.
*
                     DO 90 I = 1, NT
                        IF( RESULT( I ).GE.THRESH ) THEN
                           IF( NFAIL.EQ.0 .AND. NERRS.EQ.0 )
     $                        CALL ALAHD( NOUT, PATH )
                           IF( I.LE.2 ) THEN
                              MC = M
                              NC = N
                           ELSE
                              MC = N
                              NC = M
                           END IF
                           IF( MAX( MC, NC ).LT.1000 ) THEN
                              WRITE( NOUT, FMT = 9998 )MC, NC, ILO,
     $                           IHI, NB, NX, IMAT, I + 2, RESULT( I )
                           ELSE
                              WRITE( NOUT, FMT = 9997 )MC, NC, ILO,
     $                           IHI, NB, NX, IMAT, I + 2, RESULT( I )
                           END IF
                           NFAIL = NFAIL + 1
                        END IF
   90                CONTINUE
                     NRUN = NRUN + NT
  100             CONTINUE
  110          CONTINUE
  120       CONTINUE
  130    CONTINUE
  140 CONTINUE
*
*     Print a summary of the results.
*
      CALL ALASUM( PATH, NOUT, NFAIL, NRUN, NERRS )
*
 9999 FORMAT( ' N=', I6, ', ILO=', I5, ', IHI=', I5, ', NB=', I4,
     $      ',NX=', I4, ', type ', I2, ', test(', I1, ')=', G12.5 )
 9998 FORMAT( ' M=', I3, ', N=', I3, ', ILO=', I3, ', IHI=', I3,
     $      ', NB=', I4, ',NX=', I4, ', type ', I2, ', test(', I1, ')=',
     $      G12.5 )
 9997 FORMAT( ' M=', I4, ',N=', I4, ',ILO=', I4, ',IHI=', I4, ',NB=',
     $      I4, ',NX=', I4, ', type ', I2, ', test(', I1, ')=', G12.5 )
      RETURN
*
*     End of CCKHRD
*
      END
