      SUBROUTINE CCKBRD( DOTYPE, NM, MVAL, NN, NVAL, NK, KVAL, NNB,
     $                   NBVAL, NXVAL, THRESH, TSTERR, NMAX, A, AF, AQ,
     $                   AP, AT, C, D, E, TAUQ, TAUP, WORK, RWORK,
     $                   NOUT )
*
*  -- LAPACK test routine --
*     E. Anderson, Cray Research Inc.
*     May 25, 1995
*
*     .. Scalar Arguments ..
      LOGICAL            TSTERR
      INTEGER            NK, NM, NMAX, NN, NNB, NOUT
      REAL               THRESH
*     ..
*     .. Array Arguments ..
      LOGICAL            DOTYPE( * )
      INTEGER            KVAL( * ), MVAL( * ), NBVAL( * ), NVAL( * ),
     $                   NXVAL( * )
      REAL               D( * ), E( * ), RWORK( * )
      COMPLEX            A( * ), AF( * ), AP( * ), AQ( * ), AT( * ),
     $                   C( * ), TAUP( * ), TAUQ( * ), WORK( * )
*     ..
*
*  Purpose
*  =======
*
*  CCKBRD tests CGEBRD, CUNGBR and CUNMBR.
*
*  Arguments
*  =========
*
*  DOTYPE  (input) LOGICAL array, dimension (NTYPES)
*          The matrix types to be used for testing.  Matrices of type j
*          (for 1 <= j <= NTYPES) are used for testing if DOTYPE(j) =
*          .TRUE.; if DOTYPE(j) = .FALSE., then type j is not used.
*
*  NM      (input) INTEGER
*          The number of values of M contained in the vector MVAL.
*
*  MVAL    (input) INTEGER array, dimension (NM)
*          The values of the matrix dimension M, used as the row
*          dimension of the nonsymmetric matrix to be reduced by CGEBRD.
*
*  NN      (input) INTEGER
*          The number of values of N contained in the vector NVAL.
*
*  NVAL    (input) INTEGER array, dimension (NN)
*          The values of the matrix dimension N, used as the column
*          dimension of the nonsymmetric matrix to be reduced by CGEBRD.
*
*  NK      (input) INTEGER
*          The number of values of K contained in the vector KVAL.
*
*  KVAL    (input) INTEGER array, dimension (NK)
*          The values of the matrix dimension K, used as the other
*          dimension of the matrix C multiplied on the left or right by
*          Q or Q**T.
*
*  NNB     (input) INTEGER
*          The number of values of NB and NX contained in the
*          vectors NBVAL and NXVAL.  The blocking parameters are used
*          in pairs (NB,NX).
*
*  NBVAL   (input) INTEGER array, dimension (NNB)
*          The values of the blocksize NB.
*
*  NXVAL   (input) INTEGER array, dimension (NNB)
*          The values of the crossover point NX.
*
*  THRESH  (input) REAL
*          The threshold value for the test ratios.  A result is
*          included in the output file if RESULT >= THRESH.  To have
*          every test ratio printed, use THRESH = 0.
*
*  TSTERR  (input) LOGICAL
*          Flag that indicates whether error exits are to be tested.
*
*  NMAX    (input) INTEGER
*          The maximum value permitted for M or N, used in dimensioning
*          the work arrays.
*
*  A       (workspace) COMPLEX array, dimension (NMAX*NMAX)
*
*  AF      (workspace) COMPLEX array, dimension (NMAX*NMAX)
*
*  AQ      (workspace) COMPLEX array, dimension (NMAX*NMAX)
*
*  AP      (workspace) COMPLEX array, dimension (NMAX*NMAX)
*
*  AT      (workspace) COMPLEX array, dimension (NMAX*NMAX)
*
*  C       (workspace) COMPLEX array, dimension (NMAX*NMAX)
*
*  D       (workspace) REAL array, dimension (NMAX)
*
*  E       (workspace) REAL array, dimension (NMAX)
*
*  TAUQ    (workspace) COMPLEX array, dimension (NMAX)
*
*  TAUP    (workspace) COMPLEX array, dimension (NMAX)
*
*  WORK    (workspace) COMPLEX array, dimension (NMAX*NMAX)
*
*  RWORK   (workspace) REAL array, dimension (NMAX)
*
*  NOUT    (input) INTEGER
*          The unit number for output.
*
*     .. Parameters ..
      INTEGER            NTESTS, NTYPES
      PARAMETER          ( NTESTS = 11, NTYPES = 1 )
      COMPLEX            ONE
      PARAMETER          ( ONE = 1.0E+0 )
      COMPLEX            ROGUE
      PARAMETER          ( ROGUE = ( -1.0E+10, -1.0E+10 ) )
*     ..
*     .. Local Scalars ..
      CHARACTER          SIDE, TRANS, TRANST
      CHARACTER*3        PATH
      INTEGER            I, IK, IM, IMAT, IN, INB, INFO, ISIDE, ITRANS,
     $                   J, K, KC, LDA, LWORK, M, MC, MINMN, MODE, N,
     $                   NB, NC, NERRS, NFAIL, NRUN, NT, NX
      REAL               CNORM, COND, EPS, RESID
*     ..
*     .. Local Arrays ..
      INTEGER            ISEED( 4 ), ISEEDY( 4 )
      REAL               RESULT( NTESTS )
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      REAL               SLAMCH, CLANGE
      EXTERNAL           LSAME, SLAMCH, CLANGE
*     ..
*     .. External Subroutines ..
      EXTERNAL           ALAHD, ALASUM, CBRDT1, CERRRD, CGEBRD, CGEMM,
     $                   CLACPY, CLAGGE, CLARNV, CLASET, CLATM1, CUNGBR,
     $                   CUNMBR, XLAENV
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MAX, MIN, REAL
*     ..
*     .. Scalars in Common ..
      LOGICAL            LERR, OK
      CHARACTER*6        SRNAMT
      INTEGER            INFOT, NUNIT
*     ..
*     .. Common blocks ..
      COMMON             / INFOC / INFOT, NUNIT, OK, LERR
      COMMON             / SRNAMC / SRNAMT
*     ..
*     .. Data statements ..
      DATA               ISEEDY / 0, 0, 0, 1 /
*     ..
*     .. Executable Statements ..
*
*     Initialize constants and the random number seed.
*
      PATH( 1: 3 ) = 'BRD'
      NRUN = 0
      NFAIL = 0
      NERRS = 0
      DO 10 I = 1, 4
         ISEED( I ) = ISEEDY( I )
   10 CONTINUE
*
*     Test the error exits
*
      IF( TSTERR )
     $   CALL CERRRD( PATH, NOUT )
*
*     Print the header if NM = 0 or NN = 0 and THRESH = 0.
*
      IF( ( NM.EQ.0 .OR. NN.EQ.0 ) .AND. THRESH.EQ.0.0 )
     $   CALL ALAHD( NOUT, PATH )
      INFOT = 0
      CALL XLAENV( 2, 2 )
*
      EPS = SLAMCH( 'Epsilon' )
      LDA = NMAX
      LWORK = NMAX*NMAX
*
      DO 130 IM = 1, NM
*
*        Do for each value of M in MVAL.
*
         M = MVAL( IM )
         DO 120 IN = 1, NN
*
*           Do for each value of N in NVAL.
*
            N = NVAL( IN )
            MINMN = MIN( M, N )
            DO 110 IMAT = 1, NTYPES
*
*              Do the tests only if DOTYPE( IMAT ) is true.
*
               IF( .NOT.DOTYPE( IMAT ) )
     $            GO TO 110
*
*              Generate a nonsymmetric matrix of the desired type.
*
               MODE = 3
               COND = 2.0
               CALL CLATM1( MODE, COND, 0, 2, ISEED, D, MINMN, INFO )
               IF( M.GT.0 .AND. N.GT.0 )
     $            CALL CLAGGE( M, N, M-1, N-1, D, A, LDA, ISEED, WORK,
     $                         INFO )
*
*              Do for each pair of values (NB,NX) in NBVAL and NXVAL.
*
               DO 100 INB = 1, NNB
                  NB = NBVAL( INB )
                  CALL XLAENV( 1, NB )
                  NX = NXVAL( INB )
                  CALL XLAENV( 3, NX )
*
*                 Copy the matrix A to the array AF.
*
                  CALL CLACPY( 'Full', M, N, A, LDA, AF, LDA )
*
*                 Compute the reduction to bidiagonal form in AF.
*
                  SRNAMT = 'CGEBRD'
                  CALL CGEBRD( M, N, AF, LDA, D, E, TAUQ, TAUP, WORK,
     $                         LWORK, INFO )
*
*                 Copy details of Q
*
                  CALL CLACPY( 'Lower', M, N, AF, LDA, AQ, LDA )
                  CALL CLASET( 'Upper', M, N, ROGUE, ROGUE, AQ, LDA )
*
*                 Generate the m-by-min(m,n) matrix Q
*
                  SRNAMT = 'CUNGBR'
                  CALL CUNGBR( 'Q', M, MINMN, N, AQ, LDA, TAUQ, WORK,
     $                         LWORK, INFO )
*
*                 Copy details of PT
*
                  CALL CLACPY( 'Upper', M, N, AF, LDA, AP, LDA )
                  CALL CLASET( 'Lower', M, N, ROGUE, ROGUE, AP, LDA )
*
*                 Generate the min(m,n)-by-n matrix PT
*
                  SRNAMT = 'CUNGBR'
                  CALL CUNGBR( 'P', MINMN, N, M, AP, LDA, TAUP, WORK,
     $                         LWORK, INFO )
*
*                 Check the factorization and orthogonality of Q.
*
                  CALL CBRDT1( M, N, A, LDA, AQ, LDA, D, E, AP, LDA, AT,
     $                         LDA, WORK, LWORK, RWORK, RESULT )
*
*                 Print information about the tests that did not
*                 pass the threshold.
*
                  DO 20 I = 1, 3
                     IF( RESULT( I ).GE.THRESH ) THEN
                        IF( NFAIL.EQ.0 .AND. NERRS.EQ.0 )
     $                     CALL ALAHD( NOUT, PATH )
                        WRITE( NOUT, FMT = 9999 )M, N, NB, NX, IMAT, I,
     $                     RESULT( I )
                        NFAIL = NFAIL + 1
                     END IF
   20             CONTINUE
                  NRUN = NRUN + 3
*
*                 Copy details of Q
*
                  CALL CLACPY( 'Lower', M, N, AF, LDA, AQ, LDA )
                  CALL CLASET( 'Upper', M, N, ROGUE, ROGUE, AQ, LDA )
*
*                 Generate the m-by-m matrix Q
*
                  SRNAMT = 'CUNGBR'
                  CALL CUNGBR( 'Q', M, M, N, AQ, LDA, TAUQ, WORK, LWORK,
     $                         INFO )
*
*                 Copy details of PT
*
                  CALL CLACPY( 'Upper', M, N, AF, LDA, AP, LDA )
                  CALL CLASET( 'Lower', M, N, ROGUE, ROGUE, AP, LDA )
*
*                 Generate the n-by-n matrix PT
*
                  SRNAMT = 'CUNGBR'
                  CALL CUNGBR( 'P', N, N, M, AP, LDA, TAUP, WORK, LWORK,
     $                         INFO )
*
*                 Do for each value of K in KVAL.
*
                  DO 90 IK = 1, NK
                     K = KVAL( IK )
                     NT = 0
*
*                    Test CUNMBR with VECT = 'Q'
*
                     DO 50 ISIDE = 1, 2
                        IF( ISIDE.EQ.1 ) THEN
                           SIDE = 'Left'
                           MC = M
                           NC = K
                        ELSE
                           SIDE = 'Right'
                           MC = K
                           NC = M
                        END IF
                        KC = N
*
                        DO 40 ITRANS = 1, 2
                           IF( ITRANS.EQ.1 ) THEN
                              TRANS = 'No transpose'
                           ELSE
                              TRANS = 'Conjugate transpose'
                           END IF
*
*                          Generate MC by NC matrix C
*
                           DO 30 J = 1, NC
                              CALL CLARNV( 2, ISEED, MC,
     $                                     C( 1+( J-1 )*LDA ) )
   30                      CONTINUE
                           CNORM = CLANGE( '1', MC, NC, C, LDA, RWORK )
                           IF( CNORM.EQ.0.0 )
     $                        CNORM = 1.0
*
*                          Copy C
*
                           CALL CLACPY( 'Full', MC, NC, C, LDA, AT,
     $                                  LDA )
*
*                          Apply Q or Q' to C
*
                           SRNAMT = 'CUNMBR'
                           CALL CUNMBR( 'Q', SIDE, TRANS, MC, NC, KC,
     $                                  AF, LDA, TAUQ, AT, LDA, WORK,
     $                                  LWORK, INFO )
*
*                          Form explicit product and subtract
*
                           NT = NT + 1
                           IF( LSAME( SIDE, 'L' ) ) THEN
                              CALL CGEMM( TRANS, 'No transpose', MC, NC,
     $                                    MC, -ONE, AQ, LDA, C, LDA,
     $                                    ONE, AT, LDA )
                           ELSE
                              CALL CGEMM( 'No transpose', TRANS, MC, NC,
     $                                    NC, -ONE, C, LDA, AQ, LDA,
     $                                    ONE, AT, LDA )
                           END IF
*
                           RESID = CLANGE( '1', MC, NC, AT, LDA, RWORK )
                           RESULT( NT ) = RESID /
     $                                    ( REAL( MAX( 1, MC ) )*CNORM*
     $                                    EPS )
                           IF( RESULT( NT ).GE.THRESH ) THEN
                              IF( NFAIL.EQ.0 .AND. NERRS.EQ.0 )
     $                           CALL ALAHD( NOUT, PATH )
                              WRITE( NOUT, FMT = 9998 )MC, NC, KC, NB,
     $                           NX, IMAT, NT + 3, RESULT( NT )
                              NFAIL = NFAIL + 1
                           END IF
   40                   CONTINUE
   50                CONTINUE
*
*                    Test CUNMBR with VECT = 'P'
*
                     DO 80 ISIDE = 1, 2
                        IF( ISIDE.EQ.1 ) THEN
                           SIDE = 'Left'
                           MC = N
                           NC = K
                        ELSE
                           SIDE = 'Right'
                           MC = K
                           NC = N
                        END IF
                        KC = M
*
                        DO 70 ITRANS = 1, 2
                           IF( ITRANS.EQ.1 ) THEN
                              TRANS = 'No transpose'
                              TRANST = 'Conjugate transpose'
                           ELSE
                              TRANS = 'Conjugate transpose'
                              TRANST = 'No Transpose'
                           END IF
*
*                          Generate MC by NC matrix C
*
                           DO 60 J = 1, NC
                              CALL CLARNV( 2, ISEED, MC,
     $                                     C( 1+( J-1 )*LDA ) )
   60                      CONTINUE
                           CNORM = CLANGE( '1', MC, NC, C, LDA, RWORK )
                           IF( CNORM.EQ.0.0 )
     $                        CNORM = 1.0
*
*                          Copy C
*
                           CALL CLACPY( 'Full', MC, NC, C, LDA, AT,
     $                                  LDA )
*
*                          Apply PT or PT' (= P) to C
*
                           SRNAMT = 'CUNMBR'
                           CALL CUNMBR( 'P', SIDE, TRANS, MC, NC, KC,
     $                                  AF, LDA, TAUP, AT, LDA, WORK,
     $                                  LWORK, INFO )
*
*                          Form explicit product and subtract
*
                           NT = NT + 1
                           IF( LSAME( SIDE, 'L' ) ) THEN
                              CALL CGEMM( TRANST, 'No transpose', MC,
     $                                    NC, MC, -ONE, AP, LDA, C, LDA,
     $                                    ONE, AT, LDA )
                           ELSE
                              CALL CGEMM( 'No transpose', TRANST, MC,
     $                                    NC, NC, -ONE, C, LDA, AP, LDA,
     $                                    ONE, AT, LDA )
                           END IF
*
                           RESID = CLANGE( '1', MC, NC, AT, LDA, RWORK )
                           RESULT( NT ) = RESID /
     $                                    ( REAL( MAX( 1, MC ) )*CNORM*
     $                                    EPS )
                           IF( RESULT( NT ).GE.THRESH ) THEN
                              IF( NFAIL.EQ.0 .AND. NERRS.EQ.0 )
     $                           CALL ALAHD( NOUT, PATH )
                              WRITE( NOUT, FMT = 9998 )MC, NC, KC, NB,
     $                           NX, IMAT, NT + 3, RESULT( NT )
                              NFAIL = NFAIL + 1
                           END IF
   70                   CONTINUE
   80                CONTINUE
                     NRUN = NRUN + NT
   90             CONTINUE
  100          CONTINUE
  110       CONTINUE
  120    CONTINUE
  130 CONTINUE
*
*     Print a summary of the results.
*
      CALL ALASUM( PATH, NOUT, NFAIL, NRUN, NERRS )
*
 9999 FORMAT( ' M=', I5, ', N=', I5, ', NB=', I4, ', NX=', I4,
     $      ', type ', I2, ', test(', I2, ')=', G12.5 )
 9998 FORMAT( ' M=', I5, ', N=', I5, ', K=', I5, ', NB=', I4, ', NX=',
     $      I4, ', type ', I2, ', test(', I2, ')=', G12.5 )
      RETURN
*
*     End of CCKBRD
*
      END
