      SUBROUTINE ZBLT02( ISIDE, N, NRHS, X, LDX, Y, LDY, S, IPERM,
     &                   RESULT )
*
*  -- LAPACK test routine --
*     E. Anderson
*     April 14, 2001
*
*     .. Scalar Arguments ..
      INTEGER            ISIDE, LDX, LDY, N, NRHS
      DOUBLE PRECISION   RESULT
*     ..
*     .. Array Arguments ..
      INTEGER            IPERM( * )
      DOUBLE PRECISION   S( * )
      COMPLEX*16         X( LDX, * ), Y( LDY, * )
*     ..
*
*  Purpose
*  =======
*
*  ZBLT02 tests the permutations and scaling of an N-by-NRHS matrix X
*  as computed by ZGEBAK.
*
*  Arguments
*  =========
*
*  ISIDE   (input) INTEGER
*          An integer code representing the value of the SIDE argument
*          = 1:  SIDE = 'L' in ZGEBAK
*          = 2:  SIDE = 'R' in ZGEBAK
*
*  N       (input) INTEGER
*          The number of rows of the arrays X and Y.
*
*  NRHS    (input) INTEGER
*          The number of columns of the arrays X and Y.
*
*  X       (input) COMPLEX*16 array, dimension (N,NRHS)
*          The original matrix X before balancing.
*
*  LDX     (input) INTEGER
*          The leading dimension of the array X.  LDX >= max(1,N).
*
*  Y       (input) COMPLEX*16 array, dimension (N,NRHS)
*          The matrix X (of eigenvectors) after application of the
*          permutations and scalings from ZGEBAL as computed by ZGEBAK.
*
*  LDY     (input) INTEGER
*          The leading dimension of the array Y.  LDY >= max(1,N).
*
*  S       (input) DOUBLE PRECISION array, dimension (N)
*          Details of the permutations and scaling factors applied to A.
*          If P(j) is the index of the row and column interchanged with
*          row and column j and D(j) is the scaling factor applied to
*          row and column j, then
*          S(j) = P(j)    for j = 1,...,ILO-1
*               = D(j)    for j = ILO,...,IHI
*               = P(j)    for j = IHI+1,...,N.
*          The order in which the interchanges are made is N to IHI+1,
*          then 1 to ILO-1.
*
*  IPERM   (input) INTEGER array, dimension (N)
*          The indices of the columns or rows of A after application of
*          the pivots returned by ZGEBAL.
*
*  RESULT  (output) DOUBLE PRECISION
*          One of the test ratios computed for ZGEBAK:
*          if ISIDE = 1, maximum relative error in y^T = x^T *inv(D)*P
*          if ISIDE = 2, maximum relative error in y = P^T *D*x
*
*  =====================================================================
*
*     .. Parameters ..
      DOUBLE PRECISION   ONE, ZERO
      PARAMETER          ( ONE = 1.0D0, ZERO = 0.0D0 )
*     ..
*     .. Local Scalars ..
      INTEGER            I, IP, J
      DOUBLE PRECISION   AERR, DENO, SFMIN
      COMPLEX*16         AEXP
*     ..
*     .. External Functions ..
      DOUBLE PRECISION   DLAMCH
      EXTERNAL           DLAMCH
*     ..
      AERR = ZERO
      SFMIN = DLAMCH( 'Safe minimum' )
      IF( ISIDE.EQ.1 ) THEN
         DO J = 1, NRHS
            DO I = 1, N
               IP = IPERM(I)
               AEXP = S(I)*X(I,J)
               DENO = MAX( ABS(AEXP), ABS(Y(IP,J)), SFMIN )
               AERR = MAX( AERR, ABS(AEXP-Y(IP,J)) / DENO )
            END DO
         END DO
      ELSE
         DO J = 1, NRHS
            DO I = 1, N
               IP = IPERM(I)
               AEXP = (ONE/S(I))*X(I,J)
               DENO = MAX( ABS(AEXP), ABS(Y(IP,J)), SFMIN )
               AERR = MAX( AERR, ABS(AEXP-Y(IP,J)) / DENO )
            END DO
         END DO
      END IF
      RESULT = AERR
      RETURN
      END
