      SUBROUTINE SCKBAL( NN, NVAL, ISEED, THRESH, A, B, BP, X, XS, S,
     &                   WORK, IPIV, IPERM, NOUT, INFO )
      IMPLICIT NONE
*
*  -- LAPACK test routine --
*     E. Anderson
*     April 14, 2001
*     09-18-02:  Scale by a relatively large constant, not 1E100 (eca)
*
*     .. Scalar Arguments ..
      INTEGER            INFO, NN, NOUT
      REAL               THRESH
*     ..
*     .. Array Arguments ..
      INTEGER            IPERM(*), IPIV(*), ISEED(4), NVAL(*)
      REAL               A(*), B(*), BP(*), S(*), WORK(*), X(*), XS(*)
*     ..
*
*  Purpose
*  =======
*
*  SCKBAL tests the subroutines for balancing and back transformation.
*
*  Three test matrix types are used:
*     1) Random matrix that does not require scaling
*     2) Matrix with row sums greater than column sums
*     3) Matrix with column sums greater than row sums
*  For each type, several matrices are generated with different
*  zero patterns to test the unique combinations of
*     ILO = 1, 2, n/3, 2n/3, n-1
*  and
*     IHI = ILO+1, n/3, 2n/3, n-1, n
*
*  The test ratios computed for SGEBAL are
*     1)  0 if ILO has expected value, otherwise 1/eps
*     2)  0 if IHI has expected value, otherwise 1/eps
*     3)  maximum relative error in A11 = R1 (upper triangular)
*     4)  maximum relative error in A12 = X*D
*     5)  maximum relative error in A13 = Y
*     6)  maximum relative error in A21 = 0
*     7)  maximum relative error in A22 = inv(D)*B*D
*     8)  maximum relative error in A23 = inv(D)*Z
*     9)  maximum relative error in A31 = A32 = 0
*    10)  maximum relative error in A33 = R2 (upper triangular)
*
*  The test ratios computed for SGEBAK are
*    11)  maximum relative error in y   = P^T *D*x (SIDE = 'R')
*    12)  maximum relative error in y^T = x^T *inv(D)*P (SIDE = 'L')
*
*  Arguments
*  ==========
*
*  NN      (input) INTEGER
*          The number of values of N contained in the vector NVAL.
*
*  NVAL    (input) INTEGER array, dimension (NN)
*          The values of the matrix dimension N.
*
*  ISEED   (input/output) INTEGER array, dimension (4)
*          On entry ISEED specifies the seed of the random number
*          generator. The array elements should be between 0 and 4095;
*          if not they will be reduced mod 4096.  Also, ISEED(4) must
*          be odd.  The values of ISEED are changed on exit.
*
*  THRESH  (input) REAL
*          The threshold value for the test ratios.  A result is
*          included in the output file if RESULT >= THRESH.  To have
*          every test ratio printed, use THRESH = 0.  Note that the
*          expected value of the test ratios is O(1), so THRESH should
*          be a reasonably small multiple of 1, e.g., 10 or 100.
*
*  A       (workspace) REAL array, dimension (NMAX*NMAX)
*          where NMAX is the maximum value of N in NVAL.
*
*  B       (workspace) REAL array, dimension (NMAX*NMAX)
*
*  BP      (workspace) REAL array, dimension (NMAX*NMAX)
*
*  X       (workspace) REAL array, dimension (NMAX*NRHS)
*          where NRHS is the number of right-hand sides to test for
*          SGEBAK (currently set to 10)
*
*  XS      (workspace) REAL array, dimension (NMAX*NRHS)
*
*  S       (workspace) REAL array, dimension (NMAX)
*
*  WORK    (workspace) REAL array, dimension (NMAX)
*
*  IPIV    (workspace) INTEGER array, dimension (NMAX)
*
*  IPERM   (workspace) INTEGER array, dimension (NMAX)
*
*  NOUT    (input) INTEGER
*          The unit number for output
*
*  INFO    (output) INTEGER
*          Available as an error return code (not used).
*
*  =====================================================================
*
*     .. Parameters ..
      INTEGER            NRHS, NTESTS
      PARAMETER          ( NRHS=10, NTESTS=12 )
      REAL               ONE, ZERO
      PARAMETER          ( ONE = 1.0E0, ZERO = 0.0E0 )
*     ..
*     .. Local Scalars ..
      CHARACTER*1        JOB, SIDE
      INTEGER            HITYPE, I, I1, I2, IHI, IJOB, ILO, IMAT, IMAX,
     &                   IINFO, IP, ISIDE, ITMP, J, K, LDA, LDB,
     &                   LDX, LOTYPE, N, NCOUNT, NFAIL, NPIV, NTOT
      REAL               AERR, AEXP, ANORM, BIGNUM, BNORM, DENO, EPS,
     &                   EPSINV, SMLNUM
*     ..
*     .. Local Arrays ..
      CHARACTER*4        LTYPE( 5 )
      CHARACTER*5        HTYPE( 5 )
      REAL               TESTS( NTESTS )
*     ..
*     .. External Functions ..
      INTEGER            ISAMAX
      REAL               SLAMCH, SLANGE
      EXTERNAL           ISAMAX, SLAMCH, SLANGE
*     ..
*     .. External Subroutines ..
      EXTERNAL           ALASUM, SCOPY, SGEBAL, SGEBAK, SLARNV, SSWAP
*     ..
*     .. Data statements ..
      DATA LTYPE / '   1', '   2', ' N/3', '2N/3', ' N-1' /
      DATA HTYPE / 'ILO+1', '  N/3', ' 2N/3', '  N-1', '    N' /
*     ..
*
*     Initialize constants
*
      INFO = 0
      EPS = SLAMCH( 'Epsilon' )
      EPSINV = ONE/EPS
      SMLNUM = SLAMCH( 'Safe minimum' )*EPSINV
      BIGNUM = ONE / SMLNUM
*
*     Generate a test matrix for each N in NVAL.
*
      NFAIL = 0
      NTOT = 0
      DO 500 NCOUNT = 1, NN
         N = NVAL( NCOUNT ) 
         LDA = MAX( 1, N )
         LDB = MAX( 1, N )
         LDX = MAX( 1, N )
*
*        Generate a random matrix for SGEBAK.
*
         DO J = 1, NRHS
            CALL SLARNV( 1, ISEED, N, X(1+(J-1)*LDX) )
            DO I = 1, N
               X(I+(J-1)*LDX) = ONE + X(I+(J-1)*LDX)
            END DO
            CALL SCOPY( N, X(1+(J-1)*LDX), 1, XS(1+(J-1)*LDX), 1 )
         END DO
*
         DO 400 LOTYPE = 1, 5
            IF( LOTYPE.EQ.1 ) THEN
               ILO = 1
            ELSE IF( LOTYPE.EQ.2 ) THEN
               ILO = MIN( 2, MAX( 1, N ) )
            ELSE IF( LOTYPE.EQ.3 ) THEN
               ILO = MAX( 1, N/3 )
            ELSE IF( LOTYPE.EQ.4 ) THEN
               ILO = MAX( 1, (2*N)/3 )
            ELSE
               ILO = MAX( 1, N-1 )
            END IF
            DO 300 HITYPE = 1, 5
               IF( HITYPE.EQ.1 ) THEN
                  IHI = MIN( ILO+1, N )
               ELSE IF( HITYPE.EQ.2 ) THEN
                  IHI = MAX( 1, N/3 )
               ELSE IF( HITYPE.EQ.3 ) THEN
                  IHI = MAX( 1, (2*N)/3 )
               ELSE IF( HITYPE.EQ.4 ) THEN
                  IHI = MAX( 1, N-1 )
               ELSE
                  IHI = N
               END IF
               IF( N.LE.0 ) IHI = 0
*
*              Skip the test if IHI <= ILO, unless ILO = 1 and IHI = N.
*              Skip test 2 if it is the same as test 1, or test 4 if it
*              is the same as test 3.
*
               IF( N.GT.1 .OR. ( LOTYPE.EQ.1 .AND. HITYPE.EQ.5 ) ) THEN
                  IF( IHI.LE.ILO ) GO TO 300
               ELSE IF( HITYPE.EQ.2 .AND. IHI.EQ.MIN(ILO+1,N) ) THEN
                  GO TO 300
               ELSE IF( HITYPE.EQ.4 .AND. IHI.EQ.MAX(1,(2*N)/3) ) THEN
                  GO TO 300
               END IF
               DO 200 IMAT = 1, 3
*
*                 Generate a random matrix.
*
                  DO J = 1, ILO-1
                     CALL SLARNV( 2, ISEED, J, A(1+(J-1)*LDA) )
                  END DO
                  DO J = ILO, IHI
                     CALL SLARNV( 2, ISEED, IHI, A(1+(J-1)*LDA) )
                  END DO
                  DO J = IHI+1, N
                     CALL SLARNV( 2, ISEED, J, A(1+(J-1)*LDA) )
                  END DO
*
*                 Scale if desired.
*
                  IF( IMAT.EQ.2 ) THEN
                     DO J = 1, N-1
                        A(J+J*LDA) = BIGNUM*REAL(J)
                     END DO
                  ELSE IF( IMAT.EQ.3 ) THEN
                     DO J = ILO, IHI-1
                        A(J+1+(J-1)*LDA) = BIGNUM*REAL(J)
                     END DO
                  END IF
*
*                 Zero out the lower left border around ILO:IHI.
*
                  IF( ILO.GT.1 ) THEN
                     DO J = 1, ILO-1
                        DO I = J+1, N
                           A(I+(J-1)*LDA) = ZERO
                        END DO
                     END DO
                  END IF
                  IF( IHI.LT.N ) THEN
                     DO J = ILO, IHI
                        DO I = IHI+1, N
                           A(I+(J-1)*LDA) = ZERO
                        END DO
                     END DO
                     DO J = IHI+1, N-1
                        DO I = J+1, N
                           A(I+(J-1)*LDA) = ZERO
                        END DO
                     END DO
                  END IF
*
*                 Save the unpermuted matrix.
*
                  CALL SLACPY( 'Full', N, N, A, LDA, B, LDB )
                  ANORM = SLANGE( '1', N, N, A, LDA, S )
*
*                 Generate a set of pivots to apply to the matrix.
*
                  NPIV = (ILO-1) + (N-IHI)
                  IF( NPIV.GT.0 ) THEN
                     CALL SLARNV( 1, ISEED, NPIV, S )
                     DO I = 1, NPIV
                        IPIV(I) = 1 + N*S(I)
                     END DO
                  END IF
*
*                 Permute the rows for options 'P' or 'B'.
*                 The order of permutations doesn't really matter here.
*
                  DO I = 1, ILO-1
                     K = IPIV(I)
                     CALL SSWAP( N, A(I), LDA, A(K), LDA )
                     CALL SSWAP( N, A(1+(I-1)*LDA), 1, A(1+(K-1)*LDA),
     &                           1 )
                  END DO
                  DO I = IHI+1, N
                     K = IPIV((ILO-1)+(I-IHI))
                     CALL SSWAP( N, A(I), LDA, A(K), LDA )
                     CALL SSWAP( N, A(1+(I-1)*LDA), 1, A(1+(K-1)*LDA),
     &                           1 )
                  END DO
*
*                 Save the permuted matrix.
*
                  CALL SLACPY( 'Full', N, N, A, LDA, BP, LDB )
*
*                 Test JOB = 'N', 'P', 'S', and 'B in SGEBAL.
*
                  DO 100 IJOB = 1, 4
                     IF( IJOB.EQ.1 ) THEN
                        JOB = 'N'
                     ELSE IF( IJOB.EQ.2 ) THEN
                        JOB = 'P' 
                     ELSE IF( IJOB.EQ.3 ) THEN
                        JOB = 'S'
                     ELSE
                        JOB = 'B'
                     END IF
*
*                    Copy the matrix to A for the balancing test.
*
                     IF( IJOB.EQ.1 .OR. IJOB.EQ.3 ) THEN
                        CALL SLACPY( 'Full', N, N, B, LDB, A, LDA )
                     ELSE
                        CALL SLACPY( 'Full', N, N, BP, LDB, A, LDA )
                     END IF
*
                     CALL SGEBAL( JOB, N, A, LDA, I1, I2, S, IINFO )
                     BNORM = SLANGE( '1', N, N, A, LDA, WORK )
                     IMAX = ILO-1 + ISAMAX( IHI-ILO+1, S(ILO), 1 )
*
*                    A permuted and balanced matrix has the form
*
*                          1     ILO        IHI+1
*
*                       [ R1     X*D          Y    ]  1
*                       [                          ]
*                       [  0  inv(D)*B*D  inv(D)*Z ]  ILO
*                       [                          ]
*                       [  0      0           R2   ]  IHI+1
*
*                    where R1 and R2 are upper triangular.  The test
*                    ratios test that the permutations and scaling
*                    constants have been correctly described.  They
*                    don't check that the "right" scaling constants
*                    have been computed.
*
*                    Test the values returned in I1 and I2
*
                     DO I = 1, NTESTS
                        TESTS(I) = ZERO
                     END DO
                     IF( IJOB.EQ.1 .OR. IJOB.EQ.3 ) THEN
                        IF( I1.NE.1 ) TESTS(1) = EPSINV
                     ELSE IF( ILO.NE.I1 ) THEN
                        TESTS(1) = EPSINV
                     END IF
                     IF( IJOB.EQ.1 .OR. IJOB.EQ.3 ) THEN
                        IF( I2.NE.N ) TESTS(2) = EPSINV
                     ELSE IF( IHI.NE.I2 ) THEN
                        TESTS(2) = EPSINV
                     END IF
*
*                    Determine the permutation described by the pivots
*
                     DO I = 1, N
                        IPERM(I) = I
                     END DO
                     DO I = N, I2+1, -1
                        K = S(I)
                        ITMP = IPERM(I)
                        IPERM(I) = IPERM(K)
                        IPERM(K) = ITMP
                     END DO
                     DO I = 1, I1-1
                        K = S(I)
                        ITMP = IPERM(I)
                        IPERM(I) = IPERM(K)
                        IPERM(K) = ITMP
                     END DO
*
*                    Test that the matrix was permuted and balanced
*                    correctly.
*
                     IF( IJOB.EQ.1 .OR. IJOB.EQ.3 ) THEN
                        CALL SBLT01( N, I1, I2, B, LDB, A, LDA, S,
     &                               IPERM, TESTS(3) )
                     ELSE
                        CALL SBLT01( N, I1, I2, BP, LDB, A, LDA, S,
     &                               IPERM, TESTS(3) )
                     END IF
*
*                    Test SGEBAK for SIDE = 'R' and SIDE = 'L'.
*
                     DO ISIDE = 1, 2
                        IF( ISIDE.EQ.1 ) THEN
                           SIDE = 'R'
                        ELSE
                           SIDE = 'L'
                        END IF
*
*                       Call SGEBAK to backtransform X into Y.
*
                        CALL SLACPY( 'Full', N, NRHS, XS, LDX, X, LDX )
                        CALL SGEBAK( JOB, SIDE, N, I1, I2, S, NRHS, X,
     &                               LDX, IINFO )
*
*                       Compare the computed value of X against an
*                       inline equivalent.
*
                        CALL SBLT02( ISIDE, N, NRHS, XS, LDX, X, LDX,
     &                               S, IPERM, TESTS(10+ISIDE) )
                     END DO
                     NTOT = NTOT + 12
                     DO I = 1, 12
                        IF( TESTS(I).GE.THRESH ) THEN
                           WRITE(*,99) N, LTYPE(LOTYPE), HTYPE(HITYPE),
     &                        IMAT, JOB, I, TESTS(I)
                           NFAIL = NFAIL + 1
                        END IF
                     END DO
  100             CONTINUE
  200          CONTINUE
  300       CONTINUE
  400    CONTINUE
  500 CONTINUE
      CALL ALASUM( 'BAL', NOUT, NFAIL, NTOT, 0 )
   99 FORMAT( ' N=', I5, ', ILO= ', A4, ', IHI=', A5, ', TYPE ', I1,
     &   ', JOB=''', A1, ''', TEST(', I2, ')=', G12.5 )
      END
