      SUBROUTINE CBLT01( N, ILO, IHI, A, LDA, B, LDB, S, IPERM, TESTS )
      IMPLICIT NONE
*
*  -- LAPACK test routine --
*     E. Anderson
*     April 14, 2001
*     09-18-02:  Scale A22 by S(J)/S(I) together (eca)
*
*     .. Scalar Arguments ..
      INTEGER            IHI, ILO, LDA, LDB, N
*     ..
*     .. Array Arguments ..
      INTEGER            IPERM( * )
      REAL               S( * ), TESTS( * )
      COMPLEX            A( LDA, * ), B( LDB, * )
*     ..
*
*  Purpose
*  =======
*
*  CBLT01 tests the permutations and balancing of a general matrix A
*  as computed by CGEBAL.
*
*  Arguments
*  =========
*
*  N       (input) INTEGER
*          The order of the matrix A.  N >= 0.
*
*  ILO     (input) INTEGER
*  IHI     (input) INTEGER
*          B is assumed to be upper triangular in rows and columns
*          1:ILO-1 and IHI+1:N.
*
*  A       (input) COMPLEX array, dimension (LDA,N)
*          The original n by n matrix A.
*
*  LDA     (input) INTEGER
*          The leading dimension of the array A.  LDA >= max(1,N).
*
*  B       (input) COMPLEX array, dimension (LDB,N)
*          The permuted and balanced matrix B = P*inv(D)*A*D*P^T as
*          computed by CGEBAL.
*
*  LDB     (input) INTEGER
*          The leading dimension of the array B.  LDB >= max(1,N).
*
*  S       (input) REAL
*          Details of the permutations and scaling factors applied to A.
*          If P(j) is the index of the row and column interchanged with
*          row and column j and D(j) is the scaling factor applied to
*          row and column j, then
*          S(j) = P(j)    for j = 1,...,ILO-1
*               = D(j)    for j = ILO,...,IHI
*               = P(j)    for j = IHI+1,...,N.
*          The order in which the interchanges are made is N to IHI+1,
*          then 1 to ILO-1.
*
*  IPERM   (output) INTEGER array, dimension (N)
*          The indices of the columns or rows of A after application of
*          the pivots returned by CGEBAL.
*
*  TESTS   (output) REAL array, dimension (8)
*          The test ratios for the CGEBAL tests:
*          (1)  maximum relative error in A11 = R1 (upper triangular)
*          (2)  maximum relative error in A12 = X*D
*          (3)  maximum relative error in A13 = Y
*          (4)  maximum relative error in A21 = 0
*          (5)  maximum relative error in A22 = inv(D)*A*D
*          (6)  maximum relative error in A23 = inv(D)*Z
*          (7)  maximum relative error in A31 = A32 = 0
*          (8)  maximum relative error in A33 = R2 (upper triangular)
*
*  =====================================================================
*
*     .. Parameters ..
      REAL               ONE, ZERO
      PARAMETER          ( ONE = 1.0E0, ZERO = 0.0E0 )
*     ..
*     .. Local Scalars ..
      INTEGER            I, ITMP, J, K
      REAL               AERR, EPS, EPSINV, DENO, SFMIN
      COMPLEX            AEXP
*     ..
*     .. External Functions ..
      REAL               SLAMCH
      EXTERNAL           SLAMCH
*     ..
*
      EPS = SLAMCH( 'Epsilon' )
      EPSINV = ONE/EPS
      SFMIN = SLAMCH( 'Safe minimum' )
*
*     Determine the permutation described by the pivots.
*
      DO I = 1, N
         IPERM(I) = I
      END DO
      DO I = N, IHI+1, -1
         K = S(I)
         ITMP = IPERM(I)
         IPERM(I) = IPERM(K)
         IPERM(K) = ITMP
      END DO
      DO I = 1, ILO-1
         K = S(I)
         ITMP = IPERM(I)
         IPERM(I) = IPERM(K)
         IPERM(K) = ITMP
      END DO
*
*     Test the values of A11 (upper triangular matrix).
*
      AERR = ZERO
      DO J = 1, ILO-1
         DO I = 1, J
            AEXP = A(IPERM(I),IPERM(J))
            DENO = MAX( ABS(AEXP), ABS(B(I,J)), SFMIN )
            AERR = MAX( AERR, ABS(AEXP-B(I,J)) / DENO )
         END DO
         DO I = J+1, ILO-1
            AEXP = ZERO
            DENO = MAX( ABS(AEXP), ABS(B(I,J)), SFMIN )
            AERR = MAX( AERR, ABS(AEXP-B(I,J)) / DENO )
         END DO
      END DO
      TESTS(1) = AERR*EPSINV
*
*     Test the values of A12.
*
      AERR = ZERO
      DO J = ILO, IHI
         DO I = 1, ILO-1
            AEXP = A(IPERM(I),IPERM(J))*S(J)
            DENO = MAX( ABS(AEXP), ABS(B(I,J)), SFMIN )
            AERR = MAX( AERR, ABS(AEXP-B(I,J)) / DENO )
         END DO
      END DO
      TESTS(2) = AERR*EPSINV
*
*     Test the values of A13.
*
      AERR = ZERO
      DO J = IHI+1, N
         DO I = 1, ILO-1
            AEXP = A(IPERM(I),IPERM(J))
            DENO = MAX( ABS(AEXP), ABS(B(I,J)), SFMIN )
            AERR = MAX( AERR, ABS(AEXP-B(I,J)) / DENO )
         END DO
      END DO
      TESTS(3) = AERR*EPSINV
*
*     Test the values of A21.
*
      AERR = ZERO
      DO J = 1, ILO-1
         DO I = ILO, IHI
            AEXP = ZERO
            DENO = MAX( ABS(AEXP), ABS(B(I,J)), SFMIN )
            AERR = MAX( AERR, ABS(AEXP-B(I,J)) / DENO )
         END DO
      END DO
      TESTS(4) = AERR*EPSINV
*
*     Test the values of A22.
*     This is the only test when ILO = 1 and IHI = N.
*
      AERR = ZERO
      DO J = ILO, IHI
         DO I = ILO, IHI
            AEXP = (S(J)/S(I))*A(IPERM(I),IPERM(J))
            DENO = MAX( ABS(AEXP), ABS(B(I,J)), SFMIN)
            AERR = MAX( AERR, ABS(AEXP-B(I,J)) / DENO)
         END DO
      END DO
      TESTS(5) = AERR*EPSINV
*
*     Test the values of A23.
*
      AERR = ZERO
      DO J = IHI+1, N
         DO I = ILO, IHI
            AEXP = (ONE/S(I))*A(IPERM(I),IPERM(J))
            DENO = MAX( ABS(AEXP), ABS(B(I,J)), SFMIN )
            AERR = MAX( AERR, ABS(AEXP-B(I,J)) / DENO )
         END DO
      END DO
      TESTS(6) = AERR*EPSINV
*
*     Test the values of A31.
*
      AERR = ZERO
      DO J = 1, ILO-1
         DO I = IHI+1, N
            AEXP = ZERO
            DENO = MAX( ABS(AEXP), ABS(B(I,J)), SFMIN )
            AERR = MAX( AERR, ABS(AEXP-B(I,J)) / DENO )
         END DO
      END DO
*
*     Test the values of A32.
*
      DO J = ILO, IHI
         DO I = IHI+1, N
            AEXP = ZERO
            DENO = MAX( ABS(AEXP), ABS(B(I,J)), SFMIN )
            AERR = MAX( AERR, ABS(AEXP-B(I,J)) / DENO )
         END DO
      END DO
      TESTS(7) = AERR*EPSINV
*
*     Test the values of A33.
*
      AERR = ZERO
      DO J = IHI+1, N
         DO I = IHI+1, J
            AEXP = A(IPERM(I),IPERM(J))
            DENO = MAX( ABS(AEXP), ABS(B(I,J)), SFMIN )
            AERR = MAX( AERR, ABS(AEXP-B(I,J)) / DENO )
         END DO
         DO I = J+1, N
            AEXP = ZERO
            DENO = MAX( ABS(AEXP), ABS(B(I,J)), SFMIN )
            AERR = MAX( AERR, ABS(AEXP-B(I,J)) / DENO )
         END DO
      END DO
      TESTS(8) = AERR*EPSINV
*
*     End of CBLT01
*
      END
