#include "lapacknames.inc"
      SUBROUTINE SSYTRS( UPLO, N, NRHS, A, LDA, IPIV, B, LDB, INFO )
      USE LA_CONSTANTS
      USE LA_AUXILIARY, ONLY: ILATRS, LSAME, XERBLA
      USE LA_XSYTS2
*
*  -- LAPACK routine --
*     Based on LAPACK version 1.0, 2-29-92
*     E. Anderson, Cray Research Inc.
*     December 11, 1992
*     04-23-02:  LAPACK 3E version (eca)
*
*     .. Scalar Arguments ..
      CHARACTER          UPLO
      INTEGER            INFO, LDA, LDB, N, NRHS
*     ..
*     .. Array Arguments ..
      INTEGER            IPIV( * )
      REAL(WP)           A( LDA, * ), B( LDB, * )
*     ..
*
*  Purpose
*  =======
*
*  SSYTRS solves a system of linear equations A*X = B with a real
*  symmetric matrix A using the factorization A = U*D*U**T or
*  A = L*D*L**T computed by SSYTRF.
*
*  Arguments
*  =========
*
*  UPLO    (input) CHARACTER*1
*          Specifies whether the details of the factorization are stored
*          as an upper or lower triangular matrix.
*          = 'U':  Upper triangular (form is A = U*D*U**T)
*          = 'L':  Lower triangular (form is A = L*D*L**T)
*
*  N       (input) INTEGER
*          The order of the matrix A.  N >= 0.
*
*  NRHS    (input) INTEGER
*          The number of right hand sides, i.e., the number of columns
*          of the matrix B.  NRHS >= 0.
*
*  A       (input) REAL array, dimension (LDA,N)
*          The block diagonal matrix D and the multipliers used to
*          obtain the factor U or L as computed by SSYTRF.
*
*  LDA     (input) INTEGER
*          The leading dimension of the array A.  LDA >= max(1,N).
*
*  IPIV    (input) INTEGER array, dimension (N)
*          Details of the interchanges and the block structure of D
*          as determined by SSYTRF.
*
*  B       (input/output) REAL array, dimension (LDB,NRHS)
*          On entry, the right hand side matrix B.
*          On exit, the solution matrix X.
*
*  LDB     (input) INTEGER
*          The leading dimension of the array B.  LDB >= max(1,N).
*
*  INFO    (output) INTEGER
*          = 0:  successful exit
*          < 0:  if INFO = -k, the k-th argument had an illegal value
*
*  =====================================================================
*
*     .. Local Scalars ..
      LOGICAL            UPPER
      INTEGER            IUPLO, J, JB, NB
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MAX, MIN
*     ..
*     .. Executable Statements ..
*
      INFO = 0
      UPPER = LSAME( UPLO, 'U' )
      IF( .NOT.UPPER .AND. .NOT.LSAME( UPLO, 'L' ) ) THEN
         INFO = -1
      ELSE IF( N.LT.0 ) THEN
         INFO = -2
      ELSE IF( NRHS.LT.0 ) THEN
         INFO = -3
      ELSE IF( LDA.LT.MAX( 1, N ) ) THEN
         INFO = -5
      ELSE IF( LDB.LT.MAX( 1, N ) ) THEN
         INFO = -8
      END IF
      IF( INFO.NE.0 ) THEN
         CALL XERBLA( SPREFIX // 'SYTRS', -INFO )
         RETURN
      END IF
*
*     Quick return if possible
*
      IF( N.EQ.0 .OR. NRHS.EQ.0 )
     $   RETURN
*
*     Decode UPLO
*
      IF( UPPER ) THEN
         IUPLO = 1
      ELSE
         IUPLO = 0
      END IF
*
*     Determine the number of right hand sides to solve at a time.
*
      IF( NRHS.EQ.1 ) THEN
         NB = 1
      ELSE
         NB = MAX( 1, ILATRS( 1, SPREFIX // 'SYTRS', UPLO, N, NRHS, -1,
     $        -1 ) )
      END IF
*
      IF( NB.GE.NRHS ) THEN
         CALL LA_SYTS2( IUPLO, N, NRHS, A, LDA, IPIV, B, LDB )
      ELSE
#ifdef _OPENMP
!$OMP PARALLEL DO PRIVATE(J,JB)
!$OMP CNCALL
#endif
         DO 10 J = 1, NRHS, NB
            JB = MIN( NRHS-J+1, NB )
            CALL LA_SYTS2( IUPLO, N, JB, A(1,1), LDA, IPIV(1), B(1,J),
     $                     LDB )
   10    CONTINUE
#ifdef _OPENMP
!$OMP END PARALLEL DO
#endif
      END IF
*
      RETURN
*
*     End of SSYTRS
*
      END
