#include "lapacknames.inc"
      SUBROUTINE SPPTS2( IUPLO, N, NRHS, AP, B, LDB )
      USE LA_CONSTANTS
      USE LA_BLAS1, ONLY: LA_SCAL
      USE LA_BLAS2, ONLY: LA_GEMV, LA_GER, LA_TPSV
*
*  -- LAPACK auxiliary routine --
*     E. Anderson, Cray Research Inc.
*     December 11, 1992
*     04-16-02:  LAPACK 3E version (eca)
*
*     .. Scalar Arguments ..
      INTEGER            IUPLO, LDB, N, NRHS
*     ..
*     .. Array Arguments ..
      REAL(WP)           AP( * ), B( LDB, * )
*     ..
*
*  Purpose
*  =======
*
*  SPPTS2 solves a system of linear equations A*X = B with a symmetric
*  positive definite matrix A in packed storage using the Cholesky
*  factorization A = U'*U or A = L*L' computed by SPPTRF.  SPPTS2 can
*  be called in a parallel loop from SPPTRS.
*
*  Arguments
*  =========
*
*  IUPLO   (input) INTEGER
*          Specifies whether the factor stored in A is upper or lower
*          triangular.
*          = 1:  Upper triangular
*          = 0:  Lower triangular
*
*  N       (input) INTEGER
*          The order of the matrix A.  N >= 0.
*
*  AP      (input) REAL array, dimension (N*(N+1)/2)
*          The triangular factor U or L from the Cholesky factorization
*          A = U'*U or A = L*L', packed columnwise in a linear array.
*          The j-th column of U or L is stored in the array AP as
*          follows:
*          if UPLO = 'U', AP(i + (j-1)*j/2) = U(i,j) for 1<=i<=j;
*          if UPLO = 'L', AP(i + (j-1)*(2n-j)/2) = L(i,j) for j<=i<=n.
*
*  B       (input/output) REAL array, dimension (N)
*          On entry, the right hand side vector B for the system of
*          linear equations.
*          On exit, the solution vector, X.
*
*  =====================================================================
*
*     .. Local Scalars ..
      INTEGER            J, KK
*     ..
*     .. Executable Statements ..
*
      IF( NRHS.EQ.1 ) THEN
*
*        No vectorization across right hand sides if NRHS = 1.
*
         IF( IUPLO.EQ.1 ) THEN
*
*           Solve A*X = B where A = U'*U.
*
*           Solve U'*X = B, overwriting B with X.
*
            CALL LA_TPSV( 'Upper', 'Transpose', 'Non-unit', N, AP(1),
     $                    B(1,1), 1 )
*
*           Solve U*X = B, overwriting B with X.
*
            CALL LA_TPSV( 'Upper', 'No transpose', 'Non-unit', N, AP(1),
     $                    B(1,1), 1 )
         ELSE
*
*           Solve A*X = B where A = L*L'.
*
*           Solve L*X = B, overwriting B with X.
*
            CALL LA_TPSV( 'Lower', 'No transpose', 'Non-unit', N, AP(1),
     $                    B(1,1), 1 )
*
*           Solve L'*X = B, overwriting B with X.
*
            CALL LA_TPSV( 'Lower', 'Transpose', 'Non-unit', N, AP(1),
     $                    B(1,1), 1 )
         END IF
      ELSE
*
*        Vectorize across right hand sides if NRHS > 1.
*
         IF( IUPLO.EQ.1 ) THEN
*
*           Solve U'*X = B, overwriting B with X.
*
            KK = 1
            DO 10 J = 1, N
               CALL LA_GEMV( 'Transpose', J-1, NRHS, -ONE, B(1,1), LDB,
     $                       AP( KK ), 1, ONE, B( J, 1 ), LDB )
               CALL LA_SCAL( NRHS, ONE / AP( KK+J-1 ), B( J, 1 ), LDB )
               KK = KK + J
   10       CONTINUE
*
*           Solve U*X = B, overwriting B with X.
*
            KK = ( N*( N+1 ) ) / 2
            DO 20 J = N, 1, -1
               CALL LA_SCAL( NRHS, ONE / AP( KK ), B( J, 1 ), LDB )
               CALL LA_GER( J-1, NRHS, -ONE, AP( KK-J+1 ), 1, B( J, 1 ),
     $                      LDB, B( 1, 1 ), LDB )
               KK = KK - J
   20       CONTINUE
         ELSE
*
*           Solve L*X = B, overwriting B with X.
*
            KK = 1
            DO 30 J = 1, N - 1
               CALL LA_SCAL( NRHS, ONE / AP( KK ), B( J, 1 ), LDB )
               CALL LA_GER( N-J, NRHS, -ONE, AP( KK+1 ), 1, B( J, 1 ),
     $                      LDB, B( J+1, 1 ), LDB )
               KK = KK + ( N-J+1 )
   30       CONTINUE
            CALL LA_SCAL( NRHS, ONE / AP( KK ), B( N, 1 ), LDB )
*
*           Solve L'*X = B, overwriting B with X.
*
            KK = ( N*( N+1 ) ) / 2
            CALL LA_SCAL( NRHS, ONE / AP( KK ), B( N, 1 ), LDB )
            KK = KK - 2
            DO 40 J = N - 1, 1, -1
               CALL LA_GEMV( 'Transpose', N-J, NRHS, -ONE, B( J+1, 1 ),
     $                       LDB, AP( KK+1 ), 1, ONE, B( J, 1 ), LDB )
               CALL LA_SCAL( NRHS, ONE / AP( KK ), B( J, 1 ), LDB )
               KK = KK - ( N-J+2 )
   40       CONTINUE
         END IF
      END IF
*
      RETURN
*
*     End of SPPTS2
*
      END
