#include "lapacknames.inc"
      SUBROUTINE SPPCON( UPLO, N, AP, ANORM, RCOND, WORK, IWORK, INFO )
      USE LA_CONSTANTS
      USE LA_AUXILIARY, ONLY: LSAME, XERBLA, LA_LACN2, LA_LATPS, LA_RSCL
      USE LA_BLAS1, ONLY: LA_IAMAX
*
*  -- LAPACK routine (version 3.0) --
*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
*     Courant Institute, Argonne National Lab, and Rice University
*     March 31, 1993
*     04-16-02:  LAPACK 3E version (eca)
*
*     .. Scalar Arguments ..
      CHARACTER          UPLO
      INTEGER            INFO, N
      REAL(WP)           ANORM, RCOND
*     ..
*     .. Array Arguments ..
      INTEGER            IWORK( * )
      REAL(WP)           AP( * ), WORK( * )
*     ..
*
*  Purpose
*  =======
*
*  SPPCON estimates the reciprocal of the condition number (in the
*  1-norm) of a real symmetric positive definite packed matrix using
*  the Cholesky factorization A = U**T*U or A = L*L**T computed by
*  SPPTRF.
*
*  An estimate is obtained for norm(inv(A)), and the reciprocal of the
*  condition number is computed as RCOND = 1 / (ANORM * norm(inv(A))).
*
*  Arguments
*  =========
*
*  UPLO    (input) CHARACTER*1
*          = 'U':  Upper triangle of A is stored;
*          = 'L':  Lower triangle of A is stored.
*
*  N       (input) INTEGER
*          The order of the matrix A.  N >= 0.
*
*  AP      (input) REAL array, dimension (N*(N+1)/2)
*          The triangular factor U or L from the Cholesky factorization
*          A = U**T*U or A = L*L**T, packed columnwise in a linear
*          array.  The j-th column of U or L is stored in the array AP
*          as follows:
*          if UPLO = 'U', AP(i + (j-1)*j/2) = U(i,j) for 1<=i<=j;
*          if UPLO = 'L', AP(i + (j-1)*(2n-j)/2) = L(i,j) for j<=i<=n.
*
*  ANORM   (input) REAL
*          The 1-norm (or infinity-norm) of the symmetric matrix A.
*
*  RCOND   (output) REAL
*          The reciprocal of the condition number of the matrix A,
*          computed as RCOND = 1/(ANORM * AINVNM), where AINVNM is an
*          estimate of the 1-norm of inv(A) computed in this routine.
*
*  WORK    (workspace) REAL array, dimension (3*N)
*
*  IWORK   (workspace) INTEGER array, dimension (N)
*
*  INFO    (output) INTEGER
*          = 0:  successful exit
*          < 0:  if INFO = -i, the i-th argument had an illegal value
*
*  =====================================================================
*
*     .. Local Scalars ..
      LOGICAL            UPPER
      CHARACTER          NORMIN
      INTEGER            ITER, IX, JMAX, JUMP, KASE
      REAL(WP)           AINVNM, SCALE, SCALEL, SCALEU
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          ABS
*     ..
*     .. Executable Statements ..
*
*     Test the input parameters.
*
      INFO = 0
      UPPER = LSAME( UPLO, 'U' )
      IF( .NOT.UPPER .AND. .NOT.LSAME( UPLO, 'L' ) ) THEN
         INFO = -1
      ELSE IF( N.LT.0 ) THEN
         INFO = -2
      ELSE IF( ANORM.LT.ZERO ) THEN
         INFO = -4
      END IF
      IF( INFO.NE.0 ) THEN
         CALL XERBLA( SPREFIX // 'PPCON', -INFO )
         RETURN
      END IF
*
*     Quick return if possible
*
      RCOND = ZERO
      IF( N.EQ.0 ) THEN
         RCOND = ONE
         RETURN
      ELSE IF( ANORM.EQ.ZERO ) THEN
         RETURN
      END IF
*
*     Estimate the 1-norm of the inverse.
*
      KASE = 0
      NORMIN = 'N'
   10 CONTINUE
      CALL LA_LACN2( N, WORK(N+1), WORK(1), IWORK, AINVNM, KASE, ITER,
     $               JMAX, JUMP )
      IF( KASE.NE.0 ) THEN
         IF( UPPER ) THEN
*
*           Multiply by inv(U').
*
            CALL LA_LATPS( 'Upper', 'Transpose', 'Non-unit', NORMIN, N,
     $                     AP(1), WORK(1), SCALEL, WORK(2*N+1), INFO )
            NORMIN = 'Y'
*
*           Multiply by inv(U).
*
            CALL LA_LATPS( 'Upper', 'No transpose', 'Non-unit', NORMIN,
     $                     N, AP(1), WORK(1), SCALEU, WORK(2*N+1),
     $                     INFO )
         ELSE
*
*           Multiply by inv(L).
*
            CALL LA_LATPS( 'Lower', 'No transpose', 'Non-unit', NORMIN,
     $                     N, AP(1), WORK(1), SCALEL, WORK(2*N+1),
     $                     INFO )
            NORMIN = 'Y'
*
*           Multiply by inv(L').
*
            CALL LA_LATPS( 'Lower', 'Transpose', 'Non-unit', NORMIN, N,
     $                     AP(1), WORK(1), SCALEU, WORK(2*N+1), INFO )
         END IF
*
*        Multiply by 1/SCALE if doing so will not cause overflow.
*
         SCALE = SCALEL*SCALEU
         IF( SCALE.NE.ONE ) THEN
            IX = LA_IAMAX( N, WORK, 1 )
            IF( SCALE.LT.ABS( WORK( IX ) )*SAFMIN .OR. SCALE.EQ.ZERO )
     $         GO TO 20
            CALL LA_RSCL( N, SCALE, WORK, 1 )
         END IF
         GO TO 10
      END IF
*
*     Compute the estimate of the reciprocal condition number.
*
      IF( AINVNM.NE.ZERO )
     $   RCOND = ( ONE / AINVNM ) / ANORM
*
   20 CONTINUE
      RETURN
*
*     End of SPPCON
*
      END
