#include "lapacknames.inc"
      SUBROUTINE SLARTG( F, G, CS, SN, R )
      USE LA_CONSTANTS
*
*  -- LAPACK auxiliary routine (version 3.0) --
*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
*     Courant Institute, Argonne National Lab, and Rice University
*     September 30, 1994
*     1-23-02:  Make consistent with new BLAS standard (eca)
*     05-30-02:  LAPACK 3E version (eca)
*     11-08-02:  Fix bugs for |G| large (eca)
*
*     .. Scalar Arguments ..
      REAL(WP)           CS, F, G, R, SN
*     ..
*
*  Purpose
*  =======
*
*  SLARTG generates a plane rotation so that
*
*     [  CS  SN  ]  .  [ F ]  =  [ R ]
*     [ -SN  CS  ]     [ G ]     [ 0 ]
*
*  where CS**2 + SN**2 = 1.
*
*  The mathematical formulas used for CS and SN are
*     R = sign(F) * sqrt(F**2 + G**2)
*     CS = F / R
*     SN = G / R
*  Hence CS >= 0.  The algorithm used to compute these quantities
*  incorporates scaling to avoid overflow or underflow in computing the
*  square root of the sum of squares.
*
*  This version is discontinuous in R at F = 0 but it returns the same
*  CS and SN as CLARTG for complex inputs (F,0) and (G,0).
*
*  Arguments
*  =========
*
*  F       (input) REAL
*          The first component of vector to be rotated.
*
*  G       (input) REAL
*          The second component of vector to be rotated.
*
*  CS      (output) REAL
*          The cosine of the rotation.
*
*  SN      (output) REAL
*          The sine of the rotation.
*
*  R       (output) REAL
*          The nonzero component of the rotated vector.
*
*  =====================================================================
*
*     .. Local Scalars ..
      REAL(WP)           D, F1, FS, G1, GS, T, TT
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          ABS, SIGN, SQRT
*     ..
*     .. Executable Statements ..
*
      F1 = ABS( F )
      G1 = ABS( G )
      IF( G.EQ.ZERO ) THEN
         CS = ONE
         SN = ZERO
         R = F
      ELSE IF( F.EQ.ZERO ) THEN
         CS = ZERO
         SN = SIGN( ONE, G )
         R = G1
      ELSE IF( F1.GT.G1 ) THEN
         IF( F1.GT.SAFMIN .AND. F1.LT.SAFMAX ) THEN
            T = G / F
            TT = SQRT( ONE+T*T )
            CS = ONE / TT
            SN = T*CS
            R = F*TT
         ELSE
            F1 = MIN( SAFMAX, MAX( F1, SAFMIN ) )
            FS = F / F1
            GS = G / F1
            TT = SQRT( FS*FS + GS*GS )
            D = ONE / TT
            CS = ABS( FS )*D
            SN = GS*SIGN( D, F )
            R = F1*SIGN( TT, F )
         END IF
      ELSE
         IF( G1.GT.SAFMIN .AND. G1.LT.SAFMAX ) THEN
            T = F / G
            TT = SQRT( ONE+T*T )
            D = ONE / TT
            CS = ABS(T)*D
            SN = SIGN( D, F )*SIGN( ONE, G )
            R = G1*SIGN( TT, F )
         ELSE
            G1 = MIN( SAFMAX, MAX( G1, SAFMIN ) )
            FS = F / G1
            GS = G / G1
            TT = SQRT( FS*FS + GS*GS )
            D = ONE / TT
            CS = ABS( FS )*D
            SN = GS*SIGN( D, F )
            R = G1*SIGN( TT, F )
         END IF
      END IF
      RETURN
      END
