#include "lapacknames.inc"
      SUBROUTINE SLARGV( N, X, INCX, Y, INCY, C, INCC )
      USE LA_CONSTANTS
*
*  -- LAPACK auxiliary routine (version 3.0) --
*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
*     Courant Institute, Argonne National Lab, and Rice University
*     June 30, 1999
*     1-23-02:  Make consistent with new BLAS standard (eca)
*     05-30-02:  LAPACK 3E version (eca)
*     11-08-02:  Fix bugs for |G| large (eca)
*
*     .. Scalar Arguments ..
      INTEGER            INCC, INCX, INCY, N
*     ..
*     .. Array Arguments ..
      REAL(WP)           C( * ), X( * ), Y( * )
*     ..
*
*  Purpose
*  =======
*
*  SLARGV generates a vector of real plane rotations, determined by
*  elements of the real vectors x and y. For i = 1,2,...,n
*
*     (  c(i)  s(i) ) ( x(i) ) = ( a(i) )
*     ( -s(i)  c(i) ) ( y(i) ) = (   0  )
*
*  where c**2 + s**2 = 1.
*
*  Arguments
*  =========
*
*  N       (input) INTEGER
*          The number of plane rotations to be generated.
*
*  X       (input/output) REAL array,
*                         dimension (1+(N-1)*INCX)
*          On entry, the vector x.
*          On exit, x(i) is overwritten by a(i), for i = 1,...,n.
*
*  INCX    (input) INTEGER
*          The increment between elements of X. INCX > 0.
*
*  Y       (input/output) REAL array,
*                         dimension (1+(N-1)*INCY)
*          On entry, the vector y.
*          On exit, the sines of the plane rotations.
*
*  INCY    (input) INTEGER
*          The increment between elements of Y. INCY > 0.
*
*  C       (output) REAL array, dimension (1+(N-1)*INCC)
*          The cosines of the plane rotations.
*
*  INCC    (input) INTEGER
*          The increment between elements of C. INCC > 0.
*
*  =====================================================================
*
*     .. Local Scalars ..
      INTEGER            I, IC, IX, IY
      REAL(WP)           D, F, F1, FS, G, G1, GS, T, TT
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          ABS, SQRT
*     ..
*     .. Executable Statements ..
*
      IX = 1
      IY = 1
      IC = 1
      DO 10 I = 1, N
*
*        Use identical algorithm to SLARTG
*
         F = X( IX )
         G = Y( IY )
         F1 = ABS( F )
         G1 = ABS( G )
         IF( G.EQ.ZERO ) THEN
            C( IC ) = ONE
            X( IX ) = F
         ELSE IF( F.EQ.ZERO ) THEN
            C( IC ) = ZERO
            Y( IY ) = SIGN( ONE, G )
            X( IX ) = G1
         ELSE IF( F1.GT.G1 ) THEN
            IF( F1.GT.SAFMIN .AND. F1.LT.SAFMAX ) THEN
               T = G / F
               TT = SQRT( ONE+T*T )
               C( IC ) = ONE / TT
               Y( IY ) = T*C( IC )
               X( IX ) = F*TT
            ELSE
               F1 = MIN( SAFMAX, MAX( F1, SAFMIN ) )
               FS = F / F1
               GS = G / F1
               TT = SQRT( FS*FS + GS*GS )
               D = ONE / TT
               C( IC ) = ABS( FS )*D
               Y( IY ) = GS*SIGN( D, F )
               X( IX ) = F1*SIGN( TT, F )
            END IF
         ELSE
            IF( G1.GT.SAFMIN .AND. G1.LT.SAFMAX ) THEN
               T = F / G
               TT = SQRT( ONE+T*T )
               D = ONE / TT
               C( IC ) = ABS(T)*D
               Y( IY ) = SIGN( D, F )*SIGN( ONE, G )
               X( IX ) = G1*SIGN( TT, F )
            ELSE
               G1 = MIN( SAFMAX, MAX( G1, SAFMIN ) )
               FS = F / G1
               GS = G / G1
               TT = SQRT( FS*FS + GS*GS )
               D = ONE / TT
               C( IC ) = ABS( FS )*D
               Y( IY ) = GS*SIGN( D, F )
               X( IX ) = G1*SIGN( TT, F )
            END IF
         END IF
         IC = IC + INCC
         IY = IY + INCY
         IX = IX + INCX
   10 CONTINUE
      RETURN
*
*     End of SLARGV
*
      END
