#include "lapacknames.inc"
      SUBROUTINE SLARFG( N, ALPHA, X, INCX, TAU )
      USE LA_CONSTANTS
      USE LA_AUXILIARY, ONLY: LA_LAPY2, LA_LASSQ, LA_RSCL
*
*  -- LAPACK auxiliary routine (version 3.0) --
*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,
*     Courant Institute, Argonne National Lab, and Rice University
*     September 30, 1994
*     04-25-02:  LAPACK 3E version, based on LAWN 126 (eca)
*
*     .. Scalar Arguments ..
      INTEGER            INCX, N
      REAL(WP)           ALPHA, TAU
*     ..
*     .. Array Arguments ..
      REAL(WP)           X( * )
*     ..
*
*  Purpose
*  =======
*
*  SLARFG generates a real elementary reflector H of order n, such
*  that
*
*        H * ( alpha ) = ( beta ),   H' * H = I.
*            (   x   )   (   0  )
*
*  where alpha and beta are scalars, and x is an (n-1)-element real
*  vector. H is represented in the form
*
*        H = I - tau * ( 1 ) * ( 1 v' ) ,
*                      ( v )
*
*  where tau is a real scalar and v is a real (n-1)-element
*  vector.
*
*  If the elements of x are all zero, then tau = 0 and H is taken to be
*  the unit matrix.
*
*  Otherwise  1 <= tau <= 2.
*
*  Arguments
*  =========
*
*  N       (input) INTEGER
*          The order of the elementary reflector.
*
*  ALPHA   (input/output) REAL
*          On entry, the value alpha.
*          On exit, it is overwritten with the value beta.
*
*  X       (input/output) REAL array, dimension
*                         (1+(N-2)*abs(INCX))
*          On entry, the vector x.
*          On exit, it is overwritten with the vector v.
*
*  INCX    (input) INTEGER
*          The increment between elements of X. INCX > 0.
*
*  TAU     (output) REAL
*          The value tau.
*
*  =====================================================================
*
*     .. Local Scalars ..
      REAL(WP)           SCL, SUMSQ, XA, XB, XN
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          SIGN, SQRT
*     ..
*     .. Executable Statements ..
*
      TAU = ZERO
      IF( N.LE.1 ) RETURN
*
*     Compute the 2-norm of x
*
      SCL = ONE
      SUMSQ = ZERO
      CALL LA_LASSQ( N-1, X(1), INCX, SCL, SUMSQ )
      XN = SCL*SQRT( SUMSQ )
*
*     Compute the reflection if || x || > 0.
*
      IF( XN.GT.ZERO ) THEN
         XA = SIGN( LA_LAPY2( ALPHA, XN ), ALPHA )
         XB = ALPHA + XA
         TAU = XB / XA
         CALL LA_RSCL( N-1, XB, X(1), INCX )
         ALPHA = -XA
      END IF
*
      RETURN
*
*     End of SLARFG
*
      END
