#include "lapacknames.inc"
      SUBROUTINE SLAEIL( N, DL, IN, X )
      USE LA_CONSTANTS
*
*  -- LAPACK routine --
*     Based on LAPACK version 2.0, 9-30-94
*     E. Anderson, Cray Research Inc.
*     September 15, 1995
*     06-05-02:  LAPACK 3E version (eca)
*
*     .. Scalar Arguments ..
      INTEGER            N
*     ..
*     .. Array Arguments ..
      INTEGER            IN( * )
      REAL(WP)           DL( * ), X( * )
*     ..
*
*  Purpose
*  =======
*
*  SLAEIL solves a linear system with the unit lower triangular factor
*  L from the LU factorization of the symmetric tridiagonal matrix
*  (T - lambda*I), as computed by SLAEIF.
*
*  Arguments
*  =========
*
*  N       (input) INTEGER
*          The order of the matrix L.
*
*  DL      (input) REAL array, dimension (N-1)
*          The (n-1) multipliers that define the matrix L from
*          the LU factorization of T - lambda*I.
*
*  IN      (input) INTEGER array, dimension (N)
*          Details of the permutation matrix P.  If IN(k) = 1, then
*          row k was exchanged with row k+1; otherwise IN(k) = 0 and
*          no interchange was done.
*
*  X       (input/output) REAL array, dimension (N)
*          On entry, the right hand side vector.
*          On exit, X is overwritten by the solution vector x.
*
*  =====================================================================
*
*     .. Local Scalars ..
      INTEGER            IP, K, K1
      REAL(WP)           TEMP
*     ..
*     .. Executable Statements ..
*
*     Do the L solve 4 elements at a time
*
      DO 10 K = 1, N - 4, 4
         IP = IN( K )
         TEMP = X( K+1-IP ) - DL( K )*X( K+IP )
         X( K ) = X( K+IP )
         X( K+1 ) = TEMP
*
         IP = IN( K+1 )
         TEMP = X( K+2-IP ) - DL( K+1 )*X( K+1+IP )
         X( K+1 ) = X( K+1+IP )
         X( K+2 ) = TEMP
*
         IP = IN( K+2 )
         TEMP = X( K+3-IP ) - DL( K+2 )*X( K+2+IP )
         X( K+2 ) = X( K+2+IP )
         X( K+3 ) = TEMP
*
         IP = IN( K+3 )
         TEMP = X( K+4-IP ) - DL( K+3 )*X( K+3+IP )
         X( K+3 ) = X( K+3+IP )
         X( K+4 ) = TEMP
   10 CONTINUE
*
*     Do the L solve 1 element at a time to finish up
*
      K1 = K
      DO 20 K = K1, N - 1
         IP = IN( K )
         TEMP = X( K+1-IP ) - DL( K )*X( K+IP )
         X( K ) = X( K+IP )
         X( K+1 ) = TEMP
   20 CONTINUE
*
      RETURN
*
*     End of SLAEIL
*
      END
