#include "lapacknames.inc"
      SUBROUTINE SLAEIF( N, D, E, LAMBDA, DLF, DF, DUF, DU2, IN )
      USE LA_CONSTANTS
      USE LA_BLAS1, ONLY: LA_COPY
*
*  -- LAPACK routine --
*     Based on LAPACK version 2.0, 9-30-94
*     E. Anderson, Cray Research Inc.
*     September 15, 1995
*     06-05-02:  LAPACK 3E version (eca)
*
*     .. Scalar Arguments ..
      INTEGER            N
      REAL(WP)           LAMBDA
*     ..
*     .. Array Arguments ..
      INTEGER            IN( * )
      REAL(WP)           D( * ), DF( * ), DLF( * ), DU2( * ), DUF( * ),
     $                   E( * )
*     ..
*
*  Purpose
*  =======
*
*  SLAEIF factorizes the matrix (T - lambda*I), where T is an n by n
*  symmetric tridiagonal matrix and lambda is a scalar, as
*
*     T - lambda*I = PLU,
*
*  where P is a permutation matrix, L is a unit lower tridiagonal matrix
*  with at most one non-zero sub-diagonal element per column, and U is
*  an upper triangular matrix with at most two non-zero super-diagonal
*  elements per column.
*
*  The factorization is obtained by Gaussian elimination with partial
*  pivoting.
*
*  The parameter LAMBDA is included in the routine so that SLAEIF may
*  be used, in conjunction with SLAEIS, to obtain eigenvectors of T by
*  inverse iteration.
*
*  Arguments
*  =========
*
*  N       (input) INTEGER
*          The order of the matrix T.
*
*  D       (input) REAL array, dimension (N)
*          The n diagonal elements of T.
*
*  E       (input) REAL array, dimension (N-1)
*          The (n-1) subdiagonal (or superdiagonal) elements of T.
*
*  LAMBDA  (input) REAL
*          The scalar lambda used to form T - lambda*I
*
*  DLF     (output) REAL array, dimension (N-1)
*          The (n-1) multipliers that define the matrix L from
*          the LU factorization of T - lambda*I.
*
*  DF      (output) REAL array, dimension (N)
*          The n diagonal elements of the upper triangular
*          matrix U from the LU factorization of T - lambda*I.
*
*  DUF     (output) REAL array, dimension (N-1)
*          The (n-1) elements of the first superdiagonal of U.
*
*  DU2     (output) REAL array, dimension (N-2)
*          The (n-2) elements of the second superdiagonal of U.
*
*  IN      (output) INTEGER array, dimension (N)
*          Details of the permutation matrix P.  If IN(k) = 1, then
*          row k was exchanged with row k+1; otherwise IN(k) = 0 and
*          no interchange was done.
*
* =====================================================================
*
*     .. Local Scalars ..
      INTEGER            K
      REAL(WP)           MULT, PIV1, PIV2, SCALE1, SCALE2, TEMP
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          ABS, MAX
*     ..
*     .. Executable Statements ..
*
*     Quick returns
*
      IF( N.LE.0 )
     $   RETURN
*
      DO 10 K = 1, N
         DF( K ) = D( K ) - LAMBDA
   10 CONTINUE
      IN( N ) = 0
      IF( N.EQ.1 )
     $   RETURN
*
      SCALE1 = ABS( D( 1 ) ) + ABS( E( 1 ) )
*
      CALL LA_COPY( N-1, E, 1, DUF, 1 )
      DO 20 K = 1, N - 2
         DU2( K ) = ZERO
   20 CONTINUE
      DO 30 K = 1, N - 2
         SCALE2 = ABS( E( K ) ) + ABS( DF( K+1 ) ) + ABS( DUF( K+1 ) )
         PIV1 = ABS( DF( K ) ) / MAX( SCALE1, SMLNUM )
         IF( E( K ).EQ.ZERO ) THEN
            IN( K ) = 0
            SCALE1 = SCALE2
            DLF( K ) = ZERO
         ELSE
            PIV2 = ABS( E( K ) ) / SCALE2
            IF( PIV2.LE.PIV1 ) THEN
               IN( K ) = 0
               DLF( K ) = E( K ) / DF( K )
               DF( K+1 ) = DF( K+1 ) - DLF( K )*DUF( K )
            ELSE
               IN( K ) = 1
               MULT = DF( K ) / E( K )
               DF( K ) = E( K )
               TEMP = DF( K+1 )
               DF( K+1 ) = DUF( K ) - MULT*TEMP
               DLF( K ) = MULT
               DUF( K ) = TEMP
               DU2( K ) = DUF( K+1 )
               DUF( K+1 ) = -MULT*DU2( K )
            END IF
         END IF
   30 CONTINUE
      K = N-1
      SCALE2 = ABS( E( K ) ) + ABS( DF( K+1 ) ) + ABS( DUF( K+1 ) )
      PIV1 = ABS( DF( K ) ) / MAX( SCALE1, SMLNUM )
      IF( E( K ).EQ.ZERO ) THEN
         IN( K ) = 0
         DLF( K ) = ZERO
      ELSE
         PIV2 = ABS( E( K ) ) / SCALE2
         IF( PIV2.LE.PIV1 ) THEN
            IN( K ) = 0
            DLF( K ) = E( K ) / DF( K )
            DF( K+1 ) = DF( K+1 ) - DLF( K )*DUF( K )
         ELSE
            IN( K ) = 1
            MULT = DF( K ) / E( K )
            DF( K ) = E( K )
            TEMP = DF( K+1 )
            DF( K+1 ) = DUF( K ) - MULT*TEMP
            DLF( K ) = MULT
            DUF( K ) = TEMP
         END IF
      END IF
*
      RETURN
*
*     End of SLAEIF
*
      END
