#include "lapacknames.inc"
      SUBROUTINE SCLCPY( N, ALPHA, X, INCX, Y, INCY )
      USE LA_CONSTANTS
*
*  -- LAPACK auxiliary routine --
*     E. Anderson, Cray Research Inc.
*     September 15, 1995
*     06-05-02:  LAPACK 3E version (eca)
*
*     .. Scalar Arguments ..
      INTEGER            INCX, INCY, N
      REAL(WP)           ALPHA
*     ..
*     .. Array Arguments ..
      REAL(WP)           X( * ), Y( * )
*     ..
*
*  Purpose
*  =======
*
*  SCLCPY copies a scalar times a vector to another vector:
*
*     y <- alpha*x.
*
*  Arguments
*  =========
*
*  N       (input) INTEGER
*          The number of elements of the vectors X and Y.
*
*  ALPHA   (input) REAL
*          The scalar alpha.
*
*  X       (input ) REAL array, dimension (1+(N-1)*abs(INCX))
*          The vector x.  The i-th element of the vector x is located
*          in X(1+(I-1)*INCX).
*
*  INCX    (input) INTEGER
*          The increment between elements of X.  If INCX < 0,
*          X is processed in reverse order.
*
*  Y       (output) REAL array, dimension (1+(N-1)*abs(INCY))
*          On exit, Y is overwritten with alpha*x.
*
*  INCY    (input) INTEGER
*          The increment between elements of X.  If INCY < 0,
*          Y is processed in reverse order.
*
*  =====================================================================
*
*     .. Local Scalars ..
      INTEGER            I, IX, IY
*     ..
*     .. Executable Statements ..
*
      IF( INCX.EQ.1 .AND. INCY.EQ.1 ) THEN
         DO 10 I = 1, N
            Y( I ) = ALPHA*X( I )
   10    CONTINUE
      ELSE
         IX = 1
         IF( INCX.LT.0 )
     $      IX = 1 - ( N-1 )*INCX
         IY = 1
         IF( INCY.LT.0 )
     $      IY = 1 - ( N-1 )*INCY
         DO 20 I = 1, N
            Y( IY ) = ALPHA*X( IX )
            IY = IY + INCY
            IX = IX + INCX
   20    CONTINUE
      END IF
      RETURN
*
*     End of SCLCPY
*
      END
