      MODULE LA_XTRTI2
!
!  -- LAPACK 3E module --
!     E. Anderson
!     April 11, 2002
!
!  Purpose
!  =======
!
!  LA_XTRTI2 defines a generic interface for xTRTI2.
!
      INTERFACE LA_TRTI2
 
      SUBROUTINE STRTI2( UPLO, DIAG, N, A, LDA, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER(LEN=1), INTENT(IN) :: UPLO, DIAG
         INTEGER, INTENT(IN) :: N, LDA
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A
      END SUBROUTINE STRTI2
 
      SUBROUTINE CTRTI2( UPLO, DIAG, N, A, LDA, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER(LEN=1), INTENT(IN) :: UPLO, DIAG
         INTEGER, INTENT(IN) :: N, LDA
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A
      END SUBROUTINE CTRTI2
 
      MODULE PROCEDURE STRTI2_A2
      MODULE PROCEDURE CTRTI2_A2
 
      END INTERFACE ! LA_TRTI2
      PRIVATE STRTI2_A2, CTRTI2_A2
 
      CONTAINS
 
      SUBROUTINE STRTI2_A2( UPLO, DIAG, N, A, LDA, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER(LEN=1), INTENT(IN) :: UPLO, DIAG
         INTEGER, INTENT(IN) :: N, LDA
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         CALL STRTI2( UPLO, DIAG, N, A(1,1), LDA, INFO )
      END SUBROUTINE STRTI2_A2
 
      SUBROUTINE CTRTI2_A2( UPLO, DIAG, N, A, LDA, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER(LEN=1), INTENT(IN) :: UPLO, DIAG
         INTEGER, INTENT(IN) :: N, LDA
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         CALL CTRTI2( UPLO, DIAG, N, A(1,1), LDA, INFO )
      END SUBROUTINE CTRTI2_A2
 
      END MODULE LA_XTRTI2
