      MODULE LA_XTGSY2
!
!  -- LAPACK 3E module --
!     E. Anderson
!     June 07, 2002
!
!  Purpose
!  =======
!
!  LA_XTGSY2 defines generic interfaces for xTGSY2.
!
      INTERFACE LA_TGSY2
 
      SUBROUTINE STGSY2( TRANS, IJOB, M, N, A, LDA, B, LDB, C, LDC, D,
     $                   LDD, E, LDE, F, LDF, SCALE, RDSUM, RDSCAL,
     $                   IWORK, PQ, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: IJOB, LDA, LDB, LDC, LDD, LDE, LDF, M, N
         INTEGER, INTENT(OUT) :: INFO, PQ
         REAL(WP), INTENT(INOUT) :: RDSCAL, RDSUM
         REAL(WP), INTENT(OUT) :: SCALE
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(IN) :: A, B, D, E
         REAL(WP), INTENT(INOUT) :: C, F
      END SUBROUTINE STGSY2
 
      SUBROUTINE CTGSY2( TRANS, IJOB, M, N, A, LDA, B, LDB, C, LDC, D,
     $                   LDD, E, LDE, F, LDF, SCALE, RDSUM, RDSCAL,
     $                   INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: IJOB, LDA, LDB, LDC, LDD, LDE, LDF, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: RDSCAL, RDSUM
         REAL(WP), INTENT(OUT) :: SCALE
         COMPLEX(WP), INTENT(IN) :: A, B, D, E
         COMPLEX(WP), INTENT(INOUT) :: C, F
      END SUBROUTINE CTGSY2
 
      MODULE PROCEDURE STGSY2_A2B2C2
      MODULE PROCEDURE CTGSY2_A2B2C2
 
      END INTERFACE ! LA_TGSY2
      PRIVATE STGSY2_A2B2C2, CTGSY2_A2B2C2
 
      CONTAINS
!
!-----Natural interface for xTGSY2
!
      SUBROUTINE STGSY2_A2B2C2( TRANS, IJOB, M, N, A, LDA, B, LDB,
     $                          C, LDC, D, LDD, E, LDE, F, LDF, SCALE,
     $                          RDSUM, RDSCAL, IWORK, PQ, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: IJOB, LDA, LDB, LDC, LDD, LDE, LDF, M, N
         INTEGER, INTENT(OUT) :: INFO, PQ
         REAL(WP), INTENT(INOUT) :: RDSCAL, RDSUM
         REAL(WP), INTENT(OUT) :: SCALE
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(IN) :: A(LDA,*), B(LDB,*), D(LDD,*), E(LDE,*)
         REAL(WP), INTENT(INOUT) :: C(LDC,*), F(LDF,*)
         CALL STGSY2( TRANS, IJOB, M, N, A(1,1), LDA, B(1,1), LDB,
     $                C(1,1), LDC, D(1,1), LDD, E(1,1), LDE, F(1,1),
     $                LDF, SCALE, RDSUM, RDSCAL, IWORK(1), PQ, INFO )
      END SUBROUTINE STGSY2_A2B2C2
 
      SUBROUTINE CTGSY2_A2B2C2( TRANS, IJOB, M, N, A, LDA, B, LDB,
     $                          C, LDC, D, LDD, E, LDE, F, LDF, SCALE,
     $                          RDSUM, RDSCAL, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: IJOB, LDA, LDB, LDC, LDD, LDE, LDF, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: RDSCAL, RDSUM
         REAL(WP), INTENT(OUT) :: SCALE
         COMPLEX(WP), INTENT(IN) :: A(LDA,*), B(LDB,*), D(LDD,*),
     $                              E(LDE,*)
         COMPLEX(WP), INTENT(INOUT) :: C(LDC,*), F(LDF,*)
         CALL CTGSY2( TRANS, IJOB, M, N, A(1,1), LDA, B(1,1), LDB,
     $                C(1,1), LDC, D(1,1), LDD, E(1,1), LDE, F(1,1),
     $                LDF, SCALE, RDSUM, RDSCAL, INFO )
      END SUBROUTINE CTGSY2_A2B2C2
 
      END MODULE LA_XTGSY2
