      MODULE LA_XSYTS2
!
!  -- LAPACK 3E module --
!     E. Anderson
!     April 24, 2002
!
!  Purpose
!  =======
!
!  LA_XSYTS2 defines a generic interface for xSYTS2.
!
      INTERFACE LA_SYTS2
 
      SUBROUTINE SSYTS2( IUPLO, N, NRHS, A, LDA, IPIV, B, LDB )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: IUPLO, LDA, LDB, N, NRHS
         INTEGER, INTENT(IN) :: IPIV
         REAL(WP), INTENT(IN) :: A
         REAL(WP), INTENT(INOUT) :: B
      END SUBROUTINE SSYTS2
 
      SUBROUTINE CSYTS2( IUPLO, N, NRHS, A, LDA, IPIV, B, LDB )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: IUPLO, LDA, LDB, N, NRHS
         INTEGER, INTENT(IN) :: IPIV
         COMPLEX(WP), INTENT(IN) :: A
         COMPLEX(WP), INTENT(INOUT) :: B
      END SUBROUTINE CSYTS2
 
      MODULE PROCEDURE SSYTS2_A2I1B2
      MODULE PROCEDURE CSYTS2_A2I1B2
 
      MODULE PROCEDURE SSYTS2_A2I1B1
      MODULE PROCEDURE CSYTS2_A2I1B1
 
      END INTERFACE ! LA_SYTS2
      PRIVATE SSYTS2_A2I1B2, CSYTS2_A2I1B2
      PRIVATE SSYTS2_A2I1B1, CSYTS2_A2I1B1
 
      CONTAINS
 
      SUBROUTINE SSYTS2_A2I1B2( IUPLO, N, NRHS, A, LDA, IPIV, B, LDB )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: IUPLO, LDA, LDB, N, NRHS
         INTEGER, INTENT(IN) :: IPIV(*)
         REAL(WP), INTENT(IN) :: A(LDA,*)
         REAL(WP), INTENT(INOUT) :: B(LDB,*)
         CALL SSYTS2( IUPLO, N, NRHS, A(1,1), LDA, IPIV(1), B(1,1), LDB)
      END SUBROUTINE SSYTS2_A2I1B2
 
      SUBROUTINE CSYTS2_A2I1B2( IUPLO, N, NRHS, A, LDA, IPIV, B, LDB )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: IUPLO, LDA, LDB, N, NRHS
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(IN) :: A(LDA,*)
         COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
         CALL CSYTS2( IUPLO, N, NRHS, A(1,1), LDA, IPIV(1), B(1,1), LDB)
      END SUBROUTINE CSYTS2_A2I1B2
 
      SUBROUTINE SSYTS2_A2I1B1( IUPLO, N, NRHS, A, LDA, IPIV, B, LDB )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: IUPLO, LDA, LDB, N, NRHS
         INTEGER, INTENT(IN) :: IPIV(*)
         REAL(WP), INTENT(IN) :: A(LDA,*)
         REAL(WP), INTENT(INOUT) :: B(*)
         CALL SSYTS2( IUPLO, N, NRHS, A(1,1), LDA, IPIV(1), B(1), LDB )
      END SUBROUTINE SSYTS2_A2I1B1
 
      SUBROUTINE CSYTS2_A2I1B1( IUPLO, N, NRHS, A, LDA, IPIV, B, LDB )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: IUPLO, LDA, LDB, N, NRHS
         INTEGER, INTENT(IN) :: IPIV(*)
         COMPLEX(WP), INTENT(IN) :: A(LDA,*)
         COMPLEX(WP), INTENT(INOUT) :: B(*)
         CALL CSYTS2( IUPLO, N, NRHS, A(1,1), LDA, IPIV(1), B(1), LDB )
      END SUBROUTINE CSYTS2_A2I1B1
 
      END MODULE LA_XSYTS2
