      MODULE LA_XSYTD2
!
!  -- LAPACK 3E module --
!     E. Anderson
!     May 6, 2002
!
!  Purpose
!  =======
!
!  LA_XSYTD2 defines generic interfaces for xSYTD2 and xLATRD.
!
      INTERFACE LA_SYTD2
 
      SUBROUTINE SSYTD2( UPLO, N, A, LDA, D, E, TAU, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: D, E, TAU
      END SUBROUTINE SSYTD2
 
      MODULE PROCEDURE SSYTD2_A2D1T1
 
      END INTERFACE ! LA_SYTD2
      PRIVATE SSYTD2_A2D1T1
 
      INTERFACE LA_LATRD
 
      SUBROUTINE SLATRD( UPLO, N, NB, A, LDA, E, TAU, W, LDW )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDW, N, NB
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: E, TAU, W
      END SUBROUTINE SLATRD
 
      SUBROUTINE CLATRD( UPLO, N, NB, A, LDA, E, TAU, W, LDW )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDW, N, NB
         COMPLEX(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: E
         COMPLEX(WP), INTENT(OUT) :: TAU, W
      END SUBROUTINE CLATRD
 
      MODULE PROCEDURE SLATRD_A2T1W2
      MODULE PROCEDURE CLATRD_A2T1W2
 
      END INTERFACE ! LA_LATRD
      PRIVATE SLATRD_A2T1W2, CLATRD_A2T1W2
 
      CONTAINS
!
!-----Natural interface for xSYTD2
!
      SUBROUTINE SSYTD2_A2D1T1( UPLO, N, A, LDA, D, E, TAU, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: D(*), E(*), TAU(*)
         CALL SSYTD2( UPLO, N, A(1,1), LDA, D(1), E(1), TAU(1), INFO )
      END SUBROUTINE SSYTD2_A2D1T1
!
!-----Natural interface for xLAHRD
!
      SUBROUTINE SLATRD_A2T1W2( UPLO, N, NB, A, LDA, E, TAU, W, LDW )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDW, N, NB
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: E(*), TAU(*), W(LDW,*)
         CALL SLATRD( UPLO, N, NB, A(1,1), LDA, E(1), TAU(1), W(1,1),
     &                LDW )
      END SUBROUTINE SLATRD_A2T1W2
 
      SUBROUTINE CLATRD_A2T1W2( UPLO, N, NB, A, LDA, E, TAU, W, LDW )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, LDW, N, NB
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: E(*)
         COMPLEX(WP), INTENT(OUT) :: TAU(*), W(LDW,*)
         CALL CLATRD( UPLO, N, NB, A(1,1), LDA, E(1), TAU(1), W(1,1),
     &                LDW )
      END SUBROUTINE CLATRD_A2T1W2
 
      END MODULE LA_XSYTD2
