      MODULE LA_XSYGS2
!
!  -- LAPACK 3E module --
!     E. Anderson
!     June 07, 2002
!
!  Purpose
!  =======
!
!  LA_XSYGS2 defines generic interfaces for xSYGS2.
!
      INTERFACE LA_SYGS2
 
      SUBROUTINE SSYGS2( ITYPE, UPLO, N, A, LDA, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: ITYPE, LDA, LDB, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: B
         REAL(WP), INTENT(INOUT) :: A
      END SUBROUTINE SSYGS2
 
      MODULE PROCEDURE SSYGS2_A2B2
 
      END INTERFACE ! LA_SYGS2
      PRIVATE SSYGS2_A2B2
 
      CONTAINS
!
!-----Natural interface for xSYGS2
!
      SUBROUTINE SSYGS2_A2B2( ITYPE, UPLO, N, A, LDA, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: ITYPE, LDA, LDB, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: B(LDB,*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         CALL SSYGS2( ITYPE, UPLO, N, A(1,1), LDA, B(1,1), LDB, INFO )
      END SUBROUTINE SSYGS2_A2B2
 
      END MODULE LA_XSYGS2
      MODULE LA_XHEGS2
!
!  -- LAPACK 3E module --
!     E. Anderson
!     June 07, 2002
!
!  Purpose
!  =======
!
!  LA_XHEGS2 defines generic interfaces for xHEGS2.
!
      INTERFACE LA_HEGS2
 
      SUBROUTINE CHEGS2( ITYPE, UPLO, N, A, LDA, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: ITYPE, LDA, LDB, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: B
         COMPLEX(WP), INTENT(INOUT) :: A
      END SUBROUTINE CHEGS2
 
      MODULE PROCEDURE CHEGS2_A2B2
 
      END INTERFACE ! LA_HEGS2
      PRIVATE CHEGS2_A2B2
 
      CONTAINS
!
!-----Natural interface for xHEGS2
!
      SUBROUTINE CHEGS2_A2B2( ITYPE, UPLO, N, A, LDA, B, LDB, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: ITYPE, LDA, LDB, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: B(LDB,*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         CALL CHEGS2( ITYPE, UPLO, N, A(1,1), LDA, B(1,1), LDB, INFO )
      END SUBROUTINE CHEGS2_A2B2
 
      END MODULE LA_XHEGS2
