      MODULE LA_XPTTS2
!
!  -- LAPACK 3E module --
!     E. Anderson
!     April 17, 2002
!
!  Purpose
!  =======
!
!  LA_XPTTS2 defines a generic interface for xPTTS2.
!
      INTERFACE LA_PTTS2
 
      SUBROUTINE SPTTS2( N, NRHS, D, E, B, LDB )
         USE LA_CONSTANTS, ONLY:  WP
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         REAL(WP), INTENT(IN) :: D, E
         REAL(WP), INTENT(INOUT) :: B
      END SUBROUTINE SPTTS2
 
      SUBROUTINE CPTTS2( IUPLO, N, NRHS, D, E, B, LDB )
         USE LA_CONSTANTS, ONLY:  WP
         INTEGER, INTENT(IN) :: IUPLO, LDB, N, NRHS
         REAL(WP), INTENT(IN) :: D
         COMPLEX(WP), INTENT(IN) :: E
         COMPLEX(WP), INTENT(INOUT) :: B
      END SUBROUTINE CPTTS2
 
      MODULE PROCEDURE SPTTS2_D1E1B2
      MODULE PROCEDURE CPTTS2_D1E1B2
 
      END INTERFACE ! LA_PTTS2
      PRIVATE SPTTS2_D1E1B2, CPTTS2_D1E1B2
 
      CONTAINS
 
      SUBROUTINE SPTTS2_D1E1B2( N, NRHS, D, E, B, LDB )
         USE LA_CONSTANTS, ONLY:  WP
         INTEGER, INTENT(IN) :: LDB, N, NRHS
         REAL(WP), INTENT(IN) :: D(*), E(*)
         REAL(WP), INTENT(INOUT) :: B(LDB,*)
         CALL SPTTS2( N, NRHS, D(1), E(1), B(1,1), LDB )
      END SUBROUTINE SPTTS2_D1E1B2
 
      SUBROUTINE CPTTS2_D1E1B2( IUPLO, N, NRHS, D, E, B, LDB )
         USE LA_CONSTANTS, ONLY:  WP
         INTEGER, INTENT(IN) :: IUPLO, LDB, N, NRHS
         REAL(WP), INTENT(IN) :: D(*)
         COMPLEX(WP), INTENT(IN) :: E(*)
         COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
         CALL CPTTS2( IUPLO, N, NRHS, D(1), E(1), B(1,1), LDB )
      END SUBROUTINE CPTTS2_D1E1B2
 
      END MODULE LA_XPTTS2
