      MODULE LA_XLAUU2
!
!  -- LAPACK 3E module --
!     E. Anderson
!     April 15, 2002
!
!  Purpose
!  =======
!
!  LA_XLAUU2 defines a generic interface for xLAUU2
!
      INTERFACE LA_LAUU2
 
      SUBROUTINE SLAUU2( UPLO, N, A, LDA, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A
      END SUBROUTINE SLAUU2
 
      SUBROUTINE CLAUU2( UPLO, N, A, LDA, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A
      END SUBROUTINE CLAUU2
 
      MODULE PROCEDURE SLAUU2_A2
      MODULE PROCEDURE CLAUU2_A2
 
      END INTERFACE ! LA_LAUU2
      PRIVATE SLAUU2_A2, CLAUU2_A2
 
      CONTAINS
 
      SUBROUTINE SLAUU2_A2( UPLO, N, A, LDA, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         CALL SLAUU2( UPLO, N, A(1,1), LDA, INFO )
      END SUBROUTINE SLAUU2_A2
 
      SUBROUTINE CLAUU2_A2( UPLO, N, A, LDA, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: UPLO
         INTEGER, INTENT(IN) :: LDA, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         CALL CLAUU2( UPLO, N, A(1,1), LDA, INFO )
      END SUBROUTINE CLAUU2_A2
 
      END MODULE LA_XLAUU2
