      MODULE LA_XLATZM
!
!  -- LAPACK 3E module --
!     E. Anderson
!     May 8, 2002
!
!  Purpose
!  =======
!
!  LA_XLATZM defines a generic interface for xLATZM.
!
      INTERFACE LA_LATZM
 
      SUBROUTINE SLATZM( SIDE, M, N, V, INCV, TAU, C1, C2, LDC, WORK )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE
         INTEGER, INTENT(IN) :: INCV, LDC, M, N
         REAL(WP), INTENT(IN) :: TAU
         REAL(WP), INTENT(IN) :: V
         REAL(WP), INTENT(INOUT) :: C1, C2
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE SLATZM
 
      SUBROUTINE CLATZM( SIDE, M, N, V, INCV, TAU, C1, C2, LDC, WORK )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE
         INTEGER, INTENT(IN) :: INCV, LDC, M, N
         COMPLEX(WP), INTENT(IN) :: TAU
         COMPLEX(WP), INTENT(IN) :: V
         COMPLEX(WP), INTENT(INOUT) :: C1, C2
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE CLATZM
 
      MODULE PROCEDURE SLATZM_V1C2W1
      MODULE PROCEDURE CLATZM_V1C2W1
 
      END INTERFACE ! LA_LATZM
      PRIVATE SLATZM_V1C2W1, CLATZM_V1C2W1
 
      CONTAINS
 
      SUBROUTINE SLATZM_V1C2W1( SIDE, M, N, V, INCV, TAU, C1, C2, LDC,
     &                          WORK )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE
         INTEGER, INTENT(IN) :: INCV, LDC, M, N
         REAL(WP), INTENT(IN) :: TAU
         REAL(WP), INTENT(IN) :: V(*)
         REAL(WP), INTENT(INOUT) :: C1(LDC,*), C2(LDC,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL SLATZM( SIDE, M, N, V(1), INCV, TAU, C1(1,1), C2(1,1),
     &                LDC, WORK(1) )
      END SUBROUTINE SLATZM_V1C2W1
 
      SUBROUTINE CLATZM_V1C2W1( SIDE, M, N, V, INCV, TAU, C1, C2, LDC,
     &                          WORK )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE
         INTEGER, INTENT(IN) :: INCV, LDC, M, N
         COMPLEX(WP), INTENT(IN) :: TAU
         COMPLEX(WP), INTENT(IN) :: V(*)
         COMPLEX(WP), INTENT(INOUT) :: C1(LDC,*), C2(LDC,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL CLATZM( SIDE, M, N, V(1), INCV, TAU, C1(1,1), C2(1,1),
     &                LDC, WORK(1) )
      END SUBROUTINE CLATZM_V1C2W1
 
      END MODULE LA_XLATZM
