      MODULE LA_XLATRZ
!
!  -- LAPACK 3E module --
!     E. Anderson
!     May 8, 2002
!
!  Purpose
!  =======
!
!  LA_XLATRZ defines a generic interface for xLATRZ.
!
      INTERFACE LA_LATRZ
 
      SUBROUTINE SLATRZ( M, N, L, A, LDA, TAU, WORK )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: L, LDA, M, N
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: TAU, WORK
      END SUBROUTINE SLATRZ
 
      SUBROUTINE CLATRZ( M, N, L, A, LDA, TAU, WORK )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: L, LDA, M, N
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: TAU, WORK
      END SUBROUTINE CLATRZ
 
      MODULE PROCEDURE SLATRZ_A2T1W1
      MODULE PROCEDURE CLATRZ_A2T1W1
 
      END INTERFACE ! LA_LATRZ
      PRIVATE SLATRZ_A2T1W1, CLATRZ_A2T1W1
 
      CONTAINS
 
      SUBROUTINE SLATRZ_A2T1W1( M, N, L, A, LDA, TAU, WORK )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: L, LDA, M, N
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: TAU(*), WORK(*)
         CALL SLATRZ( M, N, L, A(1,1), LDA, TAU(1), WORK(1) )
      END SUBROUTINE SLATRZ_A2T1W1
 
      SUBROUTINE CLATRZ_A2T1W1( M, N, L, A, LDA, TAU, WORK )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: L, LDA, M, N
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: TAU(*), WORK(*)
         CALL CLATRZ( M, N, L, A(1,1), LDA, TAU(1), WORK(1) )
      END SUBROUTINE CLATRZ_A2T1W1
 
      END MODULE LA_XLATRZ
