      MODULE LA_XLARFX
!
!  -- LAPACK 3E module --
!     E. Anderson
!     June 03, 2002
!
!  Purpose
!  =======
!
!  LA_XLARFX defines generic interfaces for xLARFX.
!
      INTERFACE LA_LARFX
 
      SUBROUTINE SLARFX( SIDE, M, N, V, TAU, C, LDC, WORK )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE
         INTEGER, INTENT(IN) :: LDC, M, N
         REAL(WP), INTENT(IN) :: TAU
         REAL(WP), INTENT(IN) :: V
         REAL(WP), INTENT(INOUT) :: C
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE SLARFX
 
      SUBROUTINE CLARFX( SIDE, M, N, V, TAU, C, LDC, WORK )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE
         INTEGER, INTENT(IN) :: LDC, M, N
         COMPLEX(WP), INTENT(IN) :: TAU
         COMPLEX(WP), INTENT(IN) :: V
         COMPLEX(WP), INTENT(INOUT) :: C
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE CLARFX
 
      MODULE PROCEDURE SLARFX_V1C2W1
      MODULE PROCEDURE CLARFX_V1C2W1
 
      MODULE PROCEDURE SLARFX_V1C0W1
      MODULE PROCEDURE CLARFX_V1C0W1
 
      END INTERFACE ! LA_LARFX
      PRIVATE SLARFX_V1C2W1, CLARFX_V1C2W1
      PRIVATE SLARFX_V1C0W1, CLARFX_V1C0W1
 
      CONTAINS
!
!-----Natural interface for xLARFX
!
      SUBROUTINE SLARFX_V1C2W1( SIDE, M, N, V, TAU, C, LDC, WORK )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE
         INTEGER, INTENT(IN) :: LDC, M, N
         REAL(WP), INTENT(IN) :: TAU
         REAL(WP), INTENT(IN) :: V(*)
         REAL(WP), INTENT(INOUT) :: C(LDC,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL SLARFX( SIDE, M, N, V(1), TAU, C(1,1), LDC, WORK(1) )
      END SUBROUTINE SLARFX_V1C2W1
 
      SUBROUTINE CLARFX_V1C2W1( SIDE, M, N, V, TAU, C, LDC, WORK )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE
         INTEGER, INTENT(IN) :: LDC, M, N
         COMPLEX(WP), INTENT(IN) :: TAU
         COMPLEX(WP), INTENT(IN) :: V(*)
         COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL CLARFX( SIDE, M, N, V(1), TAU, C(1,1), LDC, WORK(1) )
      END SUBROUTINE CLARFX_V1C2W1
!
!-----Point interface for argument C only to xLARFX
!
      SUBROUTINE SLARFX_V1C0W1( SIDE, M, N, V, TAU, C, LDC, WORK )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE
         INTEGER, INTENT(IN) :: LDC, M, N
         REAL(WP), INTENT(IN) :: TAU
         REAL(WP), INTENT(IN) :: V(*)
         REAL(WP), INTENT(INOUT) :: C
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL SLARFX( SIDE, M, N, V(1), TAU, C, LDC, WORK(1) )
      END SUBROUTINE SLARFX_V1C0W1
 
      SUBROUTINE CLARFX_V1C0W1( SIDE, M, N, V, TAU, C, LDC, WORK )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE
         INTEGER, INTENT(IN) :: LDC, M, N
         COMPLEX(WP), INTENT(IN) :: TAU
         COMPLEX(WP), INTENT(IN) :: V(*)
         COMPLEX(WP), INTENT(INOUT) :: C
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL CLARFX( SIDE, M, N, V(1), TAU, C, LDC, WORK(1) )
      END SUBROUTINE CLARFX_V1C0W1
 
      END MODULE LA_XLARFX
