      MODULE LA_XLAQTR
!
!  -- LAPACK 3E module --
!     E. Anderson
!     June 06, 2002
!
!  Purpose
!  =======
!
!  LA_XLAQTR defines generic interfaces for xLAQTR.
!
      INTERFACE LA_LAQTR
 
      SUBROUTINE SLAQTR( LTRAN, LREAL, N, T, LDT, B, W, SCALE, X, WORK,
     $                   INFO )
         USE LA_CONSTANTS, ONLY: WP
         LOGICAL, INTENT(IN) :: LREAL, LTRAN
         INTEGER, INTENT(IN) :: LDT, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: W
         REAL(WP), INTENT(OUT) :: SCALE
         REAL(WP), INTENT(IN) :: B, T
         REAL(WP), INTENT(INOUT) :: X
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE SLAQTR
 
      MODULE PROCEDURE SLAQTR_T2B1W1
 
      END INTERFACE ! LA_LAQTR
      PRIVATE SLAQTR_T2B1W1
 
      CONTAINS
 
      SUBROUTINE SLAQTR_T2B1W1( LTRAN, LREAL, N, T, LDT, B, W, SCALE, X,
     $                          WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         LOGICAL, INTENT(IN) :: LREAL, LTRAN
         INTEGER, INTENT(IN) :: LDT, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: W
         REAL(WP), INTENT(OUT) :: SCALE
         REAL(WP), INTENT(IN) :: B(*), T(LDT,*)
         REAL(WP), INTENT(INOUT) :: X(*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL SLAQTR( LTRAN, LREAL, N, T(1,1), LDT, B(1), W, SCALE,
     $                X(1), WORK(1), INFO )
      END SUBROUTINE SLAQTR_T2B1W1
 
      END MODULE LA_XLAQTR
