      MODULE LA_XLAPLL
!
!  -- LAPACK 3E module --
!     E. Anderson
!     June 11, 2002
!
!  Purpose
!  =======
!
!  LA_XLAPLL defines generic interfaces for xLAPLL.
!
      INTERFACE LA_LAPLL
 
      SUBROUTINE SLAPLL( N, X, INCX, Y, INCY, SSMIN )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: INCX, INCY, N
         REAL(WP), INTENT(OUT) :: SSMIN
         REAL(WP), INTENT(INOUT) :: X, Y
      END SUBROUTINE SLAPLL
 
      SUBROUTINE CLAPLL( N, X, INCX, Y, INCY, SSMIN )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: INCX, INCY, N
         REAL(WP), INTENT(OUT) :: SSMIN
         COMPLEX(WP), INTENT(INOUT) :: X, Y
      END SUBROUTINE CLAPLL
 
      MODULE PROCEDURE SLAPLL_X1Y1
      MODULE PROCEDURE CLAPLL_X1Y1
 
      END INTERFACE ! LA_LAPLL
      PRIVATE SLAPLL_X1Y1, CLAPLL_X1Y1
 
      CONTAINS
 
      SUBROUTINE SLAPLL_X1Y1( N, X, INCX, Y, INCY, SSMIN )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: INCX, INCY, N
         REAL(WP), INTENT(OUT) :: SSMIN
         REAL(WP), INTENT(INOUT) :: X(*), Y(*)
         CALL SLAPLL( N, X(1), INCX, Y(1), INCY, SSMIN )
      END SUBROUTINE SLAPLL_X1Y1
 
      SUBROUTINE CLAPLL_X1Y1( N, X, INCX, Y, INCY, SSMIN )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: INCX, INCY, N
         REAL(WP), INTENT(OUT) :: SSMIN
         COMPLEX(WP), INTENT(INOUT) :: X(*), Y(*)
         CALL CLAPLL( N, X(1), INCX, Y(1), INCY, SSMIN )
      END SUBROUTINE CLAPLL_X1Y1
 
      END MODULE LA_XLAPLL
