      MODULE LA_XLAGTM
!
!  -- LAPACK 3E module --
!     E. Anderson
!     April 24, 2002
!
!  Purpose
!  =======
!
!  LA_XLAGTM defines a generic interface for xLAGTM
!
      INTERFACE LA_LAGTM
 
      SUBROUTINE SLAGTM( TRANS, N, NRHS, ALPHA, DL, D, DU, X, LDX, BETA,
     $                   B, LDB )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         REAL(WP), INTENT(IN) :: ALPHA, BETA
         REAL(WP), INTENT(IN) :: D, DL, DU, X
         REAL(WP), INTENT(INOUT) :: B
      END SUBROUTINE SLAGTM
 
      SUBROUTINE CLAGTM( TRANS, N, NRHS, ALPHA, DL, D, DU, X, LDX, BETA,
     $                   B, LDB )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         REAL(WP), INTENT(IN) :: ALPHA, BETA
         COMPLEX(WP), INTENT(IN) :: D, DL, DU, X
         COMPLEX(WP), INTENT(INOUT) :: B
      END SUBROUTINE CLAGTM
 
      MODULE PROCEDURE SLAGTM_D1X2B2
      MODULE PROCEDURE CLAGTM_D1X2B2
 
      END INTERFACE ! LA_LAGTM
      PRIVATE SLAGTM_D1X2B2, CLAGTM_D1X2B2
 
      CONTAINS
 
      SUBROUTINE SLAGTM_D1X2B2( TRANS, N, NRHS, ALPHA, DL, D, DU, X,
     $                          LDX, BETA, B, LDB )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         REAL(WP), INTENT(IN) :: ALPHA, BETA
         REAL(WP), INTENT(IN) :: D(*), DL(*), DU(*), X(LDX,*)
         REAL(WP), INTENT(INOUT) :: B(LDB,*)
         CALL SLAGTM( TRANS, N, NRHS, ALPHA, DL(1), D(1), DU(1), X(1,1),
     $                LDX, BETA, B(1,1), LDB )
      END SUBROUTINE SLAGTM_D1X2B2
 
      SUBROUTINE CLAGTM_D1X2B2( TRANS, N, NRHS, ALPHA, DL, D, DU, X,
     $                          LDX, BETA, B, LDB )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: TRANS
         INTEGER, INTENT(IN) :: LDB, LDX, N, NRHS
         REAL(WP), INTENT(IN) :: ALPHA, BETA
         COMPLEX(WP), INTENT(IN) :: D(*), DL(*), DU(*), X(LDX,*)
         COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
         CALL CLAGTM( TRANS, N, NRHS, ALPHA, DL(1), D(1), DU(1), X(1,1),
     $                LDX, BETA, B(1,1), LDB )
      END SUBROUTINE CLAGTM_D1X2B2
 
      END MODULE LA_XLAGTM
