      MODULE LA_XLAEDX
!
!  -- LAPACK 3E module --
!     E. Anderson
!     June 12, 2002
!
!  Purpose
!  =======
!
!  LA_XLAEDX defines generic interfaces for xLAED0 through xLAEDA,
!  auxiliary routines used in the divide-and-conquer algorithm for
!  the symmetric eigenvalue problem.
!
      INTERFACE LA_LAED0
 
      SUBROUTINE SLAED0( ICOMPQ, QSIZ, N, D, E, Q, LDQ, QSTORE, LDQS,
     $                   WORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: ICOMPQ, LDQ, LDQS, N, QSIZ
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: D, E, Q
         REAL(WP), INTENT(OUT) :: QSTORE, WORK
      END SUBROUTINE SLAED0
 
      SUBROUTINE CLAED0( QSIZ, N, D, E, Q, LDQ, QSTORE, LDQS,
     $                   WORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDQ, LDQS, N, QSIZ
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: D, E
         REAL(WP), INTENT(OUT) :: WORK
         COMPLEX(WP), INTENT(INOUT) :: Q
         COMPLEX(WP), INTENT(OUT) :: QSTORE
      END SUBROUTINE CLAED0
 
      MODULE PROCEDURE SLAED0_NAT
      MODULE PROCEDURE CLAED0_NAT
 
      END INTERFACE ! LA_LAED0
      PRIVATE SLAED0_NAT, CLAED0_NAT
 
      INTERFACE LA_LAED1
 
      SUBROUTINE SLAED1( N, D, Q, LDQ, INDXQ, RHO, CUTPNT,
     $                   WORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: CUTPNT, LDQ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: RHO
         INTEGER, INTENT(INOUT) :: INDXQ
         INTEGER, INTENT(OUT) :: IWORK
         REAL(WP), INTENT(INOUT) :: D, Q
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE SLAED1
 
      MODULE PROCEDURE SLAED1_NAT
 
      END INTERFACE ! LA_LAED1
      PRIVATE SLAED1_NAT
 
      INTERFACE LA_LAED2
 
      SUBROUTINE SLAED2( K, N, N1, D, Q, LDQ, INDXQ, RHO, Z, DLAMDA, W,
     $                   Q2, INDX, INDXC, INDXP, COLTYP, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDQ, N, N1
         INTEGER, INTENT(OUT) :: INFO, K
         REAL(WP), INTENT(INOUT) :: RHO
         INTEGER, INTENT(INOUT) :: INDXQ
         INTEGER, INTENT(OUT) :: COLTYP, INDX, INDXC, INDXP
         REAL(WP), INTENT(INOUT) :: D, Q, Z
         REAL(WP), INTENT(OUT) :: DLAMDA, Q2, W
      END SUBROUTINE SLAED2
 
      MODULE PROCEDURE SLAED2_NAT
 
      END INTERFACE ! LA_LAED2
      PRIVATE SLAED2_NAT
 
      INTERFACE LA_LAED3
 
      SUBROUTINE SLAED3( K, N, N1, D, Q, LDQ, RHO, DLAMDA, Q2, INDX,
     $                   CTOT, W, S, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDQ, N, N1
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: RHO
         INTEGER, INTENT(IN) :: CTOT, INDX
         REAL(WP), INTENT(IN) :: Q2
         REAL(WP), INTENT(INOUT) :: DLAMDA, W
         REAL(WP), INTENT(OUT) :: D, Q, S
      END SUBROUTINE SLAED3
 
      MODULE PROCEDURE SLAED3_NAT
 
      END INTERFACE ! LA_LAED3
      PRIVATE SLAED3_NAT
 
      INTERFACE LA_LAED4
 
      SUBROUTINE SLAED4( N, I, D, Z, DELTA, RHO, DLAM, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: I, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: RHO
         REAL(WP), INTENT(OUT) :: DLAM
         REAL(WP), INTENT(IN) :: D, Z
         REAL(WP), INTENT(OUT) :: DELTA
      END SUBROUTINE SLAED4
 
      MODULE PROCEDURE SLAED4_NAT
 
      END INTERFACE ! LA_LAED4
      PRIVATE SLAED4_NAT
 
      INTERFACE LA_LAED5
 
      SUBROUTINE SLAED5( I, D, Z, DELTA, RHO, DLAM )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: I
         REAL(WP), INTENT(IN) :: RHO
         REAL(WP), INTENT(OUT) :: DLAM
         REAL(WP), INTENT(IN) :: D(*), Z(*)
         REAL(WP), INTENT(OUT) :: DELTA(*)
      END SUBROUTINE SLAED5
 
      END INTERFACE ! LA_LAED5
 
      INTERFACE LA_LAED6
 
      SUBROUTINE SLAED6( KNITER, ORGATI, RHO, D, Z, FINIT, TAU, INFO )
         USE LA_CONSTANTS, ONLY: WP
         LOGICAL, INTENT(IN) :: ORGATI
         INTEGER, INTENT(IN) :: KNITER
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: FINIT, RHO
         REAL(WP), INTENT(OUT) :: TAU
         REAL(WP), INTENT(IN) :: D, Z
      END SUBROUTINE SLAED6
 
      MODULE PROCEDURE SLAED6_NAT
 
      END INTERFACE ! LA_LAED6
      PRIVATE SLAED6_NAT
 
      INTERFACE LA_LAED7
 
      SUBROUTINE SLAED7( ICOMPQ, N, QSIZ, TLVLS, CURLVL, CURPBM, D, Q,
     $                   LDQ, INDXQ, RHO, CUTPNT, QSTORE, QPTR, PRMPTR,
     $                   PERM, GIVPTR, GIVCOL, GIVNUM, WORK, IWORK,
     $                   INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: CURLVL, CURPBM, CUTPNT, ICOMPQ, LDQ, N,
     $                          QSIZ, TLVLS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: RHO
         INTEGER, INTENT(IN) :: GIVCOL, GIVPTR, PERM,
     $                          PRMPTR
         INTEGER, INTENT(INOUT) :: QPTR
         INTEGER, INTENT(OUT) :: INDXQ, IWORK
         REAL(WP), INTENT(IN) :: GIVNUM
         REAL(WP), INTENT(INOUT) :: D, Q, QSTORE
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE SLAED7
 
      SUBROUTINE CLAED7( N, CUTPNT, QSIZ, TLVLS, CURLVL, CURPBM, D, Q,
     $                   LDQ, RHO, INDXQ, QSTORE, QPTR, PRMPTR, PERM,
     $                   GIVPTR, GIVCOL, GIVNUM, WORK, RWORK, IWORK,
     $                   INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: CURLVL, CURPBM, CUTPNT, LDQ, N, QSIZ,
     $                          TLVLS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: RHO
         INTEGER, INTENT(IN) :: GIVCOL, GIVPTR, PERM,
     $                          PRMPTR
         INTEGER, INTENT(INOUT) :: QPTR
         INTEGER, INTENT(OUT) :: INDXQ, IWORK
         REAL(WP), INTENT(IN) :: GIVNUM
         REAL(WP), INTENT(INOUT) :: D, QSTORE
         REAL(WP), INTENT(OUT) :: RWORK
         COMPLEX(WP), INTENT(INOUT) :: Q
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE CLAED7
 
      MODULE PROCEDURE SLAED7_NAT
      MODULE PROCEDURE CLAED7_NAT
 
      END INTERFACE ! LA_LAED7
      PRIVATE SLAED7_NAT, CLAED7_NAT
 
      INTERFACE LA_LAED8
 
      SUBROUTINE SLAED8( ICOMPQ, K, N, QSIZ, D, Q, LDQ, INDXQ, RHO,
     $                   CUTPNT, Z, DLAMDA, Q2, LDQ2, W, PERM, GIVPTR,
     $                   GIVCOL, GIVNUM, INDXP, INDX, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: CUTPNT, ICOMPQ, LDQ, LDQ2, N, QSIZ
         INTEGER, INTENT(OUT) :: GIVPTR, INFO, K
         REAL(WP), INTENT(INOUT) :: RHO
         INTEGER, INTENT(IN) :: INDXQ
         INTEGER, INTENT(OUT) :: GIVCOL, INDX, INDXP, PERM
         REAL(WP), INTENT(INOUT) :: D, Q, Z
         REAL(WP), INTENT(OUT) :: DLAMDA, GIVNUM, Q2, W
      END SUBROUTINE SLAED8
 
      SUBROUTINE CLAED8( K, N, QSIZ, Q, LDQ, D, RHO, CUTPNT, Z, DLAMDA,
     $                   Q2, LDQ2, W, INDXP, INDX, INDXQ, PERM, GIVPTR,
     $                   GIVCOL, GIVNUM, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: CUTPNT, LDQ, LDQ2, N, QSIZ
         INTEGER, INTENT(OUT) :: GIVPTR, INFO, K
         REAL(WP), INTENT(INOUT) :: RHO
         INTEGER, INTENT(IN) :: INDXQ
         INTEGER, INTENT(OUT) :: GIVCOL, INDX, INDXP, PERM
         REAL(WP), INTENT(INOUT) :: D, Z
         COMPLEX(WP), INTENT(INOUT) :: Q
         REAL(WP), INTENT(OUT) :: DLAMDA, GIVNUM, W
         COMPLEX(WP), INTENT(OUT) :: Q2
      END SUBROUTINE CLAED8
 
      MODULE PROCEDURE SLAED8_NAT
      MODULE PROCEDURE CLAED8_NAT
 
      END INTERFACE ! LA_LAED8
      PRIVATE SLAED8_NAT, CLAED8_NAT
 
      INTERFACE LA_LAED9
 
      SUBROUTINE SLAED9( K, KSTART, KSTOP, N, D, Q, LDQ, RHO, DLAMDA, W,
     $                   S, LDS, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: K, KSTART, KSTOP, LDQ, LDS, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: RHO
         REAL(WP), INTENT(IN) :: DLAMDA, W
         REAL(WP), INTENT(OUT) :: D, Q, S
      END SUBROUTINE SLAED9
 
      MODULE PROCEDURE SLAED9_NAT
 
      END INTERFACE ! LA_LAED9
      PRIVATE SLAED9_NAT
 
      INTERFACE LA_LAEDA
 
      SUBROUTINE SLAEDA( N, TLVLS, CURLVL, CURPBM, PRMPTR, PERM, GIVPTR,
     $                   GIVCOL, GIVNUM, Q, QPTR, Z, ZTEMP, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: CURLVL, CURPBM, N, TLVLS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: GIVCOL, GIVPTR, PERM, PRMPTR, QPTR
         REAL(WP), INTENT(IN) :: GIVNUM, Q
         REAL(WP), INTENT(OUT) :: Z, ZTEMP
      END SUBROUTINE SLAEDA
 
      MODULE PROCEDURE SLAEDA_NAT
 
      END INTERFACE ! LA_LAEDA
      PRIVATE SLAEDA_NAT
 
      CONTAINS
 
      SUBROUTINE SLAED0_NAT( ICOMPQ, QSIZ, N, D, E, Q, LDQ, QSTORE,
     $                       LDQS, WORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: ICOMPQ, LDQ, LDQS, N, QSIZ
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: D(*), E(*), Q(LDQ,*)
         REAL(WP), INTENT(OUT) :: QSTORE(LDQS,*), WORK(*)
         CALL SLAED0( ICOMPQ, QSIZ, N, D(1), E(1), Q(1,1), LDQ,
     $                QSTORE(1,1), LDQS, WORK(1), IWORK(1), INFO )
      END SUBROUTINE SLAED0_NAT
 
      SUBROUTINE CLAED0_NAT( QSIZ, N, D, E, Q, LDQ, QSTORE, LDQS,
     $                       WORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDQ, LDQS, N, QSIZ
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: D(*), E(*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         COMPLEX(WP), INTENT(INOUT) :: Q(LDQ,*)
         COMPLEX(WP), INTENT(OUT) :: QSTORE(LDQS,*)
         CALL CLAED0( QSIZ, N, D(1), E(1), Q(1,1), LDQ,
     $                QSTORE(1,1), LDQS, WORK(1), IWORK(1), INFO )
      END SUBROUTINE CLAED0_NAT
 
      SUBROUTINE SLAED1_NAT( N, D, Q, LDQ, INDXQ, RHO, CUTPNT,
     $                       WORK, IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: CUTPNT, LDQ, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: RHO
         INTEGER, INTENT(INOUT) :: INDXQ(*)
         INTEGER, INTENT(OUT) :: IWORK(*)
         REAL(WP), INTENT(INOUT) :: D(*), Q(LDQ,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL SLAED1( N, D(1), Q(1,1), LDQ, INDXQ(1), RHO, CUTPNT,
     $                WORK(1), IWORK(1), INFO )
      END SUBROUTINE SLAED1_NAT
 
      SUBROUTINE SLAED2_NAT( K, N, N1, D, Q, LDQ, INDXQ, RHO, Z, DLAMDA,
     $                       W, Q2, INDX, INDXC, INDXP, COLTYP, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDQ, N, N1
         INTEGER, INTENT(OUT) :: INFO, K
         REAL(WP), INTENT(INOUT) :: RHO
         INTEGER, INTENT(INOUT) :: INDXQ(*)
         INTEGER, INTENT(OUT) :: COLTYP(*), INDX(*), INDXC(*), INDXP(*)
         REAL(WP), INTENT(INOUT) :: D(*), Q(LDQ,*), Z(*)
         REAL(WP), INTENT(OUT) :: DLAMDA(*), Q2(*), W(*)
         CALL SLAED2( K, N, N1, D(1), Q(1,1), LDQ, INDXQ(1), RHO, Z(1),
     $                DLAMDA(1), W(1), Q2(1), INDX(1), INDXC(1),
     $                INDXP(1), COLTYP(1), INFO )
      END SUBROUTINE SLAED2_NAT
 
      SUBROUTINE SLAED3_NAT( K, N, N1, D, Q, LDQ, RHO, DLAMDA, Q2, INDX,
     $                       CTOT, W, S, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDQ, N, N1
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: RHO
         INTEGER, INTENT(IN) :: CTOT(*), INDX(*)
         REAL(WP), INTENT(IN) :: Q2(*)
         REAL(WP), INTENT(INOUT) :: DLAMDA(*), W(*)
         REAL(WP), INTENT(OUT) :: D(*), Q(LDQ,*), S(*)
         CALL SLAED3( K, N, N1, D(1), Q(1,1), LDQ, RHO, DLAMDA(1),
     $                Q2(1), INDX(1), CTOT(1), W(1), S(1), INFO )
      END SUBROUTINE SLAED3_NAT
 
      SUBROUTINE SLAED4_NAT( N, I, D, Z, DELTA, RHO, DLAM, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: I, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: RHO
         REAL(WP), INTENT(OUT) :: DLAM
         REAL(WP), INTENT(IN) :: D(*), Z(*)
         REAL(WP), INTENT(OUT) :: DELTA(*)
         CALL SLAED4( N, I, D(1), Z(1), DELTA(1), RHO, DLAM, INFO )
      END SUBROUTINE SLAED4_NAT
 
      SUBROUTINE SLAED6_NAT( KNITER, ORGATI, RHO, D, Z, FINIT, TAU,
     $                       INFO )
         USE LA_CONSTANTS, ONLY: WP
         LOGICAL, INTENT(IN) :: ORGATI
         INTEGER, INTENT(IN) :: KNITER
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: FINIT, RHO
         REAL(WP), INTENT(OUT) :: TAU
         REAL(WP), INTENT(IN) :: D(3), Z(3)
         CALL SLAED6( KNITER, ORGATI, RHO, D(1), Z(1), FINIT, TAU, INFO)
      END SUBROUTINE SLAED6_NAT
 
      SUBROUTINE SLAED7_NAT( ICOMPQ, N, QSIZ, TLVLS, CURLVL, CURPBM, D,
     $                       Q, LDQ, INDXQ, RHO, CUTPNT, QSTORE, QPTR,
     $                       PRMPTR, PERM, GIVPTR, GIVCOL, GIVNUM, WORK,
     $                       IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: CURLVL, CURPBM, CUTPNT, ICOMPQ, LDQ, N,
     $                          QSIZ, TLVLS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: RHO
         INTEGER, INTENT(IN) :: GIVCOL(2,*), GIVPTR(*), PERM(*),
     $                          PRMPTR(*)
         INTEGER, INTENT(INOUT) :: QPTR(*)
         INTEGER, INTENT(OUT) :: INDXQ(*), IWORK(*)
         REAL(WP), INTENT(IN) :: GIVNUM(2,*)
         REAL(WP), INTENT(INOUT) :: D(*), Q(LDQ,*), QSTORE(*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL SLAED7( ICOMPQ, N, QSIZ, TLVLS, CURLVL, CURPBM, D(1),
     $                Q(1,1), LDQ, INDXQ(1), RHO, CUTPNT, QSTORE(1),
     $                QPTR(1), PRMPTR(1), PERM(1), GIVPTR(1),
     $                GIVCOL(1,1), GIVNUM(1,1), WORK(1), IWORK(1), INFO)
      END SUBROUTINE SLAED7_NAT
 
      SUBROUTINE CLAED7_NAT( N, CUTPNT, QSIZ, TLVLS, CURLVL, CURPBM, D,
     $                       Q, LDQ, RHO, INDXQ, QSTORE, QPTR, PRMPTR,
     $                       PERM, GIVPTR, GIVCOL, GIVNUM, WORK, RWORK,
     $                       IWORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: CURLVL, CURPBM, CUTPNT, LDQ, N, QSIZ,
     $                          TLVLS
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: RHO
         INTEGER, INTENT(IN) :: GIVCOL(2,*), GIVPTR(*), PERM(*),
     $                          PRMPTR(*)
         INTEGER, INTENT(INOUT) :: QPTR(*)
         INTEGER, INTENT(OUT) :: INDXQ(*), IWORK(*)
         REAL(WP), INTENT(IN) :: GIVNUM(2,*)
         REAL(WP), INTENT(INOUT) :: D(*), QSTORE(*)
         REAL(WP), INTENT(OUT) :: RWORK(*)
         COMPLEX(WP), INTENT(INOUT) :: Q(LDQ,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL CLAED7( N, CUTPNT, QSIZ, TLVLS, CURLVL, CURPBM, D(1),
     $                Q(1,1), LDQ, RHO, INDXQ(1), QSTORE(1), QPTR(1),
     $                PRMPTR(1), PERM(1), GIVPTR(1), GIVCOL(1,1),
     $                GIVNUM(1,1), WORK(1), RWORK(1), IWORK(1), INFO)
      END SUBROUTINE CLAED7_NAT
 
      SUBROUTINE SLAED8_NAT( ICOMPQ, K, N, QSIZ, D, Q, LDQ, INDXQ, RHO,
     $                       CUTPNT, Z, DLAMDA, Q2, LDQ2, W, PERM,
     $                       GIVPTR, GIVCOL, GIVNUM, INDXP, INDX, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: CUTPNT, ICOMPQ, LDQ, LDQ2, N, QSIZ
         INTEGER, INTENT(OUT) :: GIVPTR, INFO, K
         REAL(WP), INTENT(INOUT) :: RHO
         INTEGER, INTENT(IN) :: INDXQ(*)
         INTEGER, INTENT(OUT) :: GIVCOL(2,*), INDX(*), INDXP(*), PERM(*)
         REAL(WP), INTENT(INOUT) :: D(*), Q(LDQ,*), Z(*)
         REAL(WP), INTENT(OUT) :: DLAMDA(*), GIVNUM(2,*), Q2(LDQ2,*),
     $                            W(*)
         CALL SLAED8( ICOMPQ, K, N, QSIZ, D(1), Q(1,1), LDQ, INDXQ(1),
     $                RHO, CUTPNT, Z(1), DLAMDA(1), Q2(1,1), LDQ2, W(1),
     $                PERM(1), GIVPTR, GIVCOL(1,1), GIVNUM(1,1),
     $                INDXP(1), INDX(1), INFO )
      END SUBROUTINE SLAED8_NAT
 
      SUBROUTINE CLAED8_NAT( K, N, QSIZ, Q, LDQ, D, RHO, CUTPNT, Z,
     $                       DLAMDA, Q2, LDQ2, W, INDXP, INDX, INDXQ,
     $                       PERM, GIVPTR, GIVCOL, GIVNUM, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: CUTPNT, LDQ, LDQ2, N, QSIZ
         INTEGER, INTENT(OUT) :: GIVPTR, INFO, K
         REAL(WP), INTENT(INOUT) :: RHO
         INTEGER, INTENT(IN) :: INDXQ(*)
         INTEGER, INTENT(OUT) :: GIVCOL(2,*), INDX(*), INDXP(*), PERM(*)
         REAL(WP), INTENT(INOUT) :: D(*), Z(*)
         COMPLEX(WP), INTENT(INOUT) :: Q(LDQ,*)
         REAL(WP), INTENT(OUT) :: DLAMDA(*), GIVNUM(2,*), W(*)
         COMPLEX(WP), INTENT(OUT) :: Q2(LDQ2,*)
         CALL CLAED8( K, N, QSIZ, Q(1,1), LDQ, D(1), RHO, CUTPNT, Z(1),
     $                DLAMDA(1), Q2(1,1), LDQ2, W(1), INDXP(1), INDX(1),
     $                INDXQ(1), PERM(1), GIVPTR, GIVCOL(1,1),
     $                GIVNUM(1,1), INFO )
      END SUBROUTINE CLAED8_NAT
 
      SUBROUTINE SLAED9_NAT( K, KSTART, KSTOP, N, D, Q, LDQ, RHO,
     $                       DLAMDA, W, S, LDS, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: K, KSTART, KSTOP, LDQ, LDS, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: RHO
         REAL(WP), INTENT(IN) :: DLAMDA(*), W(*)
         REAL(WP), INTENT(OUT) :: D(*), Q(LDQ,*), S(LDS,*)
         CALL SLAED9( K, KSTART, KSTOP, N, D(1), Q(1,1), LDQ, RHO,
     $                DLAMDA(1), W(1), S(1,1), LDS, INFO )
      END SUBROUTINE SLAED9_NAT
 
      SUBROUTINE SLAEDA_NAT( N, TLVLS, CURLVL, CURPBM, PRMPTR, PERM,
     $                       GIVPTR, GIVCOL, GIVNUM, Q, QPTR, Z, ZTEMP,
     $                       INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: CURLVL, CURPBM, N, TLVLS
         INTEGER, INTENT(OUT) :: INFO
         INTEGER, INTENT(IN) :: GIVCOL(2,*), GIVPTR(*), PERM(*),
     $                          PRMPTR(*), QPTR(*)
         REAL(WP), INTENT(IN) :: GIVNUM(2,*), Q(*)
         REAL(WP), INTENT(OUT) :: Z(*), ZTEMP(*)
         CALL SLAEDA( N, TLVLS, CURLVL, CURPBM, PRMPTR(1), PERM(1),
     $                GIVPTR(1), GIVCOL(1,1), GIVNUM(1,1), Q(1),
     $                QPTR(1), Z(1), ZTEMP(1), INFO )
      END SUBROUTINE SLAEDA_NAT
 
      END MODULE LA_XLAEDX
