      MODULE LA_XGEQR2
!
!  -- LAPACK 3E module --
!     E. Anderson
!     April 26, 2002
!
!  Purpose
!  =======
!
!  LA_XGEQR2 defines generic interfaces for xGEQR2, xORG2R/xUNG2R,
!  and xORM2R/xUNM2R.
!
      INTERFACE LA_GEQR2
 
      SUBROUTINE SGEQR2( M, N, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: TAU, WORK
      END SUBROUTINE SGEQR2
 
      SUBROUTINE CGEQR2( M, N, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: TAU, WORK
      END SUBROUTINE CGEQR2
 
      MODULE PROCEDURE SGEQR2_A2T1W1
      MODULE PROCEDURE CGEQR2_A2T1W1
 
      END INTERFACE ! LA_GEQR2
      PRIVATE SGEQR2_A2T1W1, CGEQR2_A2T1W1
 
      INTERFACE LA_ORG2R
 
      SUBROUTINE SORG2R( M, N, K, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: TAU
         REAL(WP), INTENT(INOUT) :: A
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE SORG2R
 
      MODULE PROCEDURE SORG2R_A2T1W1
 
      END INTERFACE ! LA_ORG2R
 
      INTERFACE LA_UNG2R
 
      SUBROUTINE CUNG2R( M, N, K, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: TAU
         COMPLEX(WP), INTENT(INOUT) :: A
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE CUNG2R
 
      MODULE PROCEDURE CUNG2R_A2T1W1
 
      END INTERFACE ! LA_UNG2R
      PRIVATE SORG2R_A2T1W1, CUNG2R_A2T1W1
 
      INTERFACE LA_ORM2R
 
      SUBROUTINE SORM2R( SIDE, TRANS, M, N, K, A, LDA, TAU, C, LDC,
     $                   WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: A, TAU
         REAL(WP), INTENT(INOUT) :: C
         REAL(WP), INTENT(OUT) :: WORK
      END SUBROUTINE SORM2R
 
      MODULE PROCEDURE SORM2R_A2T1W1
 
      END INTERFACE ! LA_ORM2R
 
      INTERFACE LA_UNM2R
 
      SUBROUTINE CUNM2R( SIDE, TRANS, M, N, K, A, LDA, TAU, C, LDC,
     $                   WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: A, TAU
         COMPLEX(WP), INTENT(INOUT) :: C
         COMPLEX(WP), INTENT(OUT) :: WORK
      END SUBROUTINE CUNM2R
 
      MODULE PROCEDURE CUNM2R_A2T1W1
 
      END INTERFACE ! LA_UNM2R
      PRIVATE SORM2R_A2T1W1, CUNM2R_A2T1W1
 
      CONTAINS
!
!-----Natural interface for xGEQR2
!
      SUBROUTINE SGEQR2_A2T1W1( M, N, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: TAU(*), WORK(*)
         CALL SGEQR2( M, N, A(1,1), LDA, TAU(1), WORK(1), INFO )
      END SUBROUTINE SGEQR2_A2T1W1
 
      SUBROUTINE CGEQR2_A2T1W1( M, N, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: TAU(*), WORK(*)
         CALL CGEQR2( M, N, A(1,1), LDA, TAU(1), WORK(1), INFO )
      END SUBROUTINE CGEQR2_A2T1W1
!
!-----Natural interface for xORG2R/xUNG2R
!
      SUBROUTINE SORG2R_A2T1W1( M, N, K, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: TAU(*)
         REAL(WP), INTENT(INOUT) :: A(LDA,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL SORG2R( M, N, K, A(1,1), LDA, TAU(1), WORK(1), INFO )
      END SUBROUTINE SORG2R_A2T1W1
 
      SUBROUTINE CUNG2R_A2T1W1( M, N, K, A, LDA, TAU, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         INTEGER, INTENT(IN) :: K, LDA, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: TAU(*)
         COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL CUNG2R( M, N, K, A(1,1), LDA, TAU(1), WORK(1), INFO )
      END SUBROUTINE CUNG2R_A2T1W1
!
!-----Natural interface for xORM2R/xUNM2R
!
      SUBROUTINE SORM2R_A2T1W1( SIDE, TRANS, M, N, K, A, LDA, TAU, C,
     $                          LDC, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, M, N
         INTEGER, INTENT(OUT) :: INFO
         REAL(WP), INTENT(IN) :: A(LDA,*), TAU(*)
         REAL(WP), INTENT(INOUT) :: C(LDC,*)
         REAL(WP), INTENT(OUT) :: WORK(*)
         CALL SORM2R( SIDE, TRANS, M, N, K, A(1,1), LDA, TAU(1), C(1,1),
     $                LDC, WORK(1), INFO )
      END SUBROUTINE SORM2R_A2T1W1
 
      SUBROUTINE CUNM2R_A2T1W1( SIDE, TRANS, M, N, K, A, LDA, TAU, C,
     $                          LDC, WORK, INFO )
         USE LA_CONSTANTS, ONLY: WP
         CHARACTER, INTENT(IN) :: SIDE, TRANS
         INTEGER, INTENT(IN) :: K, LDA, LDC, M, N
         INTEGER, INTENT(OUT) :: INFO
         COMPLEX(WP), INTENT(IN) :: A(LDA,*), TAU(*)
         COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
         COMPLEX(WP), INTENT(OUT) :: WORK(*)
         CALL CUNM2R( SIDE, TRANS, M, N, K, A(1,1), LDA, TAU(1), C(1,1),
     $                LDC, WORK(1), INFO )
      END SUBROUTINE CUNM2R_A2T1W1
 
      END MODULE LA_XGEQR2
